package online.filter.deploy;

import java.io.File;
import java.util.Objects;

import javax.servlet.ServletContext;

import org.apache.catalina.Globals;
import org.apache.logging.log4j.LogManager;

import javassist.ClassPool;
import javassist.NotFoundException;

/**
 * HotDeploy用ユーティリティ
 * @author Tadashi Nakayama
 */
public final class S2HotDeployUtil {

	/**
	 * コンストラクタ
	 */
	private S2HotDeployUtil() {
		throw new AssertionError();
	}

	/**
	 * クラスパス設定
	 * @param context サーブレットコンテキスト
	 */
	public static void setClassPath(final ServletContext context) {
		String path = Objects.toString(context.getAttribute(Globals.CLASS_PATH_ATTR), "");
		ClassPool pool = ClassPool.getDefault();
		for (final String str : path.split(File.pathSeparator)) {
			try {
				if (!str.isEmpty()) {
					pool.appendClassPath(str);
				}
			} catch (final NotFoundException e) {
				LogManager.getLogger().info(e.getMessage());
				continue;
			}
		}
	}
}
