package batch.status;

import java.sql.Timestamp;

import core.util.DateUtil;

/**
 * ジョブ詳細管理
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public class JobDetail {
	/** identifier field */
	private volatile long jobSeq;

	/** identifier field */
	private int batSeq;

	/** persistent field */
	private int pid;

	/** persistent field */
	private String batName;

	/** persistent field */
	private int batSts;

	/** nullable persistent field */
	private Timestamp startDtm;

	/** nullable persistent field */
	private Timestamp stopDtm;

	/** nullable persistent field */
	private String msgTxt;

	/**
	 * バッチ名取得
	 *
	 * @return バッチ名
	 */
	public final String getBatName() {
		return this.batName;
	}

	/**
	 * バッチ名設定
	 *
	 * @param val バッチ名
	 */
	public final void setBatName(final String val) {
		this.batName = val;
	}

	/**
	 * バッチ連番取得
	 *
	 * @return バッチ連番
	 */
	public final int getBatSeq() {
		return this.batSeq;
	}

	/**
	 * バッチ連番設定
	 *
	 * @param val バッチ連番
	 */
	public final void setBatSeq(final int val) {
		this.batSeq = val;
	}

	/**
	 * バッチステータス取得
	 *
	 * @return バッチステータス
	 */
	public final int getBatSts() {
		return this.batSts;
	}

	/**
	 * バッチステータス設定
	 *
	 * @param val バッチステータス
	 */
	public final void setBatSts(final int val) {
		this.batSts = val;
	}

	/**
	 * ジョブ連番取得
	 *
	 * @return ジョブ連番
	 */
	public final long getJobSeq() {
		return this.jobSeq;
	}

	/**
	 * ジョブ連番設定
	 *
	 * @param val ジョブ連番
	 */
	public final void setJobSeq(final long val) {
		this.jobSeq = val;
	}

	/**
	 * 処理開始日時取得
	 *
	 * @return 処理開始日時
	 */
	public final Timestamp getStartDtm() {
		return DateUtil.copyOf(this.startDtm);
	}

	/**
	 * 処理開始日時設定
	 *
	 * @param val 処理開始日時
	 */
	public final void setStartDtm(final Timestamp val) {
		this.startDtm = DateUtil.copyOf(val);
	}

	/**
	 * メッセージテキスト取得
	 *
	 * @return メッセージテキスト
	 */
	public final String getMsgTxt() {
		return this.msgTxt;
	}

	/**
	 * メッセージテキスト設定
	 *
	 * @param val メッセージテキスト
	 */
	public final void setMsgTxt(final String val) {
		this.msgTxt = val;
	}

	/**
	 * PID取得
	 *
	 * @return PID
	 */
	public final int getPid() {
		return this.pid;
	}

	/**
	 * PID設定
	 *
	 * @param val PID
	 */
	public final void setPid(final int val) {
		this.pid = val;
	}

	/**
	 * 処理終了日時取得
	 *
	 * @return 処理終了日時
	 */
	public final Timestamp getStopDtm() {
		return DateUtil.copyOf(this.stopDtm);
	}

	/**
	 * 処理終了日時設定
	 *
	 * @param val 処理終了日時
	 */
	public final void setStopDtm(final Timestamp val) {
		this.stopDtm = DateUtil.copyOf(val);
	}
}
