package batch.status;

import java.sql.Timestamp;

import core.util.ArrayUtil;
import core.util.DateUtil;

/**
 * ジョブ管理
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public class Job {
	/** identifier field */
	private volatile long jobSeq;

	/** persistent field */
	private String jobId;

	/** persistent field */
	private String userId;

	/** persistent field */
	private Timestamp torokuDtm;

	/** nullable persistent field */
	private String[] jobParam = {};

	/** nullable persistent field */
	private String[] execParam = {};

	/** nullable persistent field */
	private String gamenParam;

	/** persistent field */
	private String jobName;

	/** persistent field */
	private String ipAdd;

	/** nullable persistent field */
	private String hostId;

	/** persistent field */
	private int jobSts;

	/** nullable persistent field */
	private String msgTxt;

	/** nullable persistent field */
	private String remark;

	/**
	 * 備考取得
	 *
	 * @return 備考
	 */
	public final String getRemark() {
		return this.remark;
	}

	/**
	 * 備考設定
	 *
	 * @param val 備考
	 */
	public final void setRemark(final String val) {
		this.remark = val;
	}

	/**
	 * ジョブパラメタ取得
	 *
	 * @return ジョブパラメタ
	 */
	public final String[] getJobParam() {
		return this.jobParam.clone();
	}

	/**
	 * ジョブパラメタ設定
	 *
	 * @param val ジョブパラメタ（スペース区切り毎に1パラメタ）
	 */
	public final void setJobParam(final String... val) {
		this.jobParam = ArrayUtil.copyOf(val, new String[0]);
	}

	/**
	 * バッチ実行時パラメタ取得
	 *
	 * @return 実行時パラメタ
	 */
	public final String[] getExecParam() {
		return this.execParam.clone();
	}

	/**
	 * バッチ実行時パラメタ設定
	 *
	 * @param val 実行時パラメタ（スペース区切り毎に1パラメタ）
	 */
	public final void setExecParam(final String... val) {
		this.execParam = ArrayUtil.copyOf(val, new String[0]);
	}

	/**
	 * 画面パラメタ取得
	 *
	 * @return 画面パラメタ
	 */
	public final String getGamenParam() {
		return this.gamenParam;
	}

	/**
	 * 画面パラメタ設定
	 *
	 * @param val 画面パラメタ
	 */
	public final void setGamenParam(final String val) {
		this.gamenParam = val;
	}

	/**
	 * ホストID取得
	 *
	 * @return ホストID
	 */
	public final String getHostId() {
		return this.hostId;
	}

	/**
	 * ホストID設定
	 *
	 * @param val ホストID
	 */
	public final void setHostId(final String val) {
		this.hostId = val;
	}

	/**
	 * IPアドレス取得
	 *
	 * @return IPアドレス
	 */
	public final String getIp() {
		return this.ipAdd;
	}

	/**
	 * IPアドレス設定
	 *
	 * @param val IPアドレス
	 */
	public final void setIp(final String val) {
		this.ipAdd = val;
	}

	/**
	 * ジョブID取得
	 *
	 * @return ジョブID
	 */
	public final String getJobId() {
		return this.jobId;
	}

	/**
	 * ジョブID設定
	 *
	 * @param val ジョブID
	 */
	public final void setJobId(final String val) {
		this.jobId = val;
	}

	/**
	 * ジョブ名取得
	 *
	 * @return ジョブ名
	 */
	public final String getJobName() {
		return this.jobName;
	}

	/**
	 * ジョブ名設定
	 *
	 * @param val ジョブ名
	 */
	public final void setJobName(final String val) {
		this.jobName = val;
	}

	/**
	 * ジョブ連番取得
	 *
	 * @return ジョブ連番
	 */
	public final long getJobSeq() {
		return this.jobSeq;
	}

	/**
	 * ジョブ連番設定
	 *
	 * @param val ジョブ連番
	 */
	public final void setJobSeq(final long val) {
		this.jobSeq = val;
	}

	/**
	 * ジョブステータス取得
	 *
	 * @return ジョブステータス
	 */
	public final int getJobSts() {
		return this.jobSts;
	}

	/**
	 * ジョブステータス設定
	 *
	 * @param val ジョブステータス
	 */
	public final void setJobSts(final int val) {
		this.jobSts = val;
	}

	/**
	 * メッセージテキスト取得
	 *
	 * @return メッセージテキスト
	 */
	public final String getMsgTxt() {
		return this.msgTxt;
	}

	/**
	 * メッセージテキスト設定
	 *
	 * @param val メッセージテキスト
	 */
	public final void setMsgTxt(final String val) {
		this.msgTxt = val;
	}

	/**
	 * 登録日時取得
	 *
	 * @return 登録日時
	 */
	public final Timestamp getDateTime() {
		return DateUtil.copyOf(this.torokuDtm);
	}

	/**
	 * 登録日時設定
	 *
	 * @param val 登録日時
	 */
	public final void setDateTime(final Timestamp val) {
		this.torokuDtm = DateUtil.copyOf(val);
	}

	/**
	 * ユーザID取得
	 *
	 * @return ユーザID
	 */
	public final String getUid() {
		return this.userId;
	}

	/**
	 * ユーザID設定
	 *
	 * @param val ユーザID
	 */
	public final void setUid(final String val) {
		this.userId = val;
	}
}
