package batch.base;

import java.util.List;

import core.util.bean.Pair;

/**
 * バッチ作成のためのインタフェース
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public interface Batch {
	/** バッチ終了ステータス：正常終了 */
	int RET_SUCCESS = 0;
	/** バッチ終了ステータス：正常終了(対象データなし) */
	int RET_NODATA = 100;

	/** バッチ終了ステータス：警告終了 */
	int RET_WARNING = 101;

	/** バッチ終了ステータス：異常終了(起動環境/パラメタエラー) */
	int RET_PARAM_ERROR = 102;
	/** バッチ終了ステータス：異常終了(環境設定エラー) */
	int RET_ENV_ERROR = 103;
	/** バッチ終了ステータス：異常終了(DBエラー) */
	int RET_DB_ERROR = 104;
	/** バッチ終了ステータス：異常終了 */
	int RET_FAILED = 105;

	/** バッチ終了ステータス：中止終了 */
	int RET_CANCELED = 110;

	/**
	 * バッチパラメタ取得
	 *
	 * @param val バッチパラメタ
	 */
	void setBatchParameter(BatchParameter val);

	/**
	 * バッチ処理メソッド。
	 *
	 * @param args パラメタ
	 * @return 処理結果
	 */
	int perform(String... args);

	/**
	 * バッチ処理名称取得メソッド。
	 *
	 * @return 処理名称
	 */
	String getBatchName();

	/**
	 * メッセージ取得
	 *
	 * @return メッセージ
	 */
	String getMessage();

	/**
	 * ファイルリスト取得
	 *
	 * @return ファイルリスト
	 */
	List<Pair<String, String>> getOutputFiles();
}
