package common.db.jdbc;

import java.nio.charset.Charset;
import java.sql.Connection;

/**
 * Jdbcセッション
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public interface JdbcSession {

	/**
	 * コネクション取得
	 * @param name プロパティ項目名
	 * @return コネクション
	 */
	Connection getConnection(String name);

	/**
	 * コネクション取得
	 * @param name プロパティ項目名
	 * @return コネクション
	 */
	Connection newConnection(String name);

	/**
	 * ユーザ取得
	 * @param name 接続名
	 * @return ユーザ
	 */
	String getUser(String name);

	/**
	 * パスワード取得
	 * @param name 接続名
	 * @return パスワード
	 */
	String getPassword(String name);

	/**
	 * 接続Url取得
	 * @param name 接続名
	 * @return 接続Url
	 */
	String getUrl(String name);

	/**
	 * DBエンコーディング取得
	 * @param name プロパティ項目名
	 * @return エンコーディング文字列
	 */
	Charset getCharset(String name);
}
