/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.commons.chain2.web.servlet;


import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Locale;



/**
 * Mock Object for HttpServletResponse
 */
public final class MockHttpServletResponse implements HttpServletResponse {



    // ------------------------------------------------------ Instance Variables


    private Locale locale = null;


    // ---------------------------------------------------------- Public Methods


    // --------------------------------------------- HttpServletResponse Methods

    /**
     * @see javax.servlet.http.HttpServletResponse#addCookie(javax.servlet.http.Cookie)
     */
    @Override
    public void addCookie(final Cookie cookie) {
        throw new UnsupportedOperationException();
    }

    /**
     * @see javax.servlet.http.HttpServletResponse#addDateHeader(java.lang.String, long)
     */
    @Override
    public void addDateHeader(final String name, final long value) {
        throw new UnsupportedOperationException();
    }

    /**
     * @see javax.servlet.http.HttpServletResponse#addHeader(java.lang.String, java.lang.String)
     */
    @Override
    public void addHeader(final String name, final String value) {
        throw new UnsupportedOperationException();
    }

    /**
     * @see javax.servlet.http.HttpServletResponse#addIntHeader(java.lang.String, int)
     */
    @Override
    public void addIntHeader(final String name, final int value) {
        throw new UnsupportedOperationException();
    }

    /**
     * @see javax.servlet.http.HttpServletResponse#containsHeader(java.lang.String)
     */
    @Override
    public boolean containsHeader(final String name) {
        throw new UnsupportedOperationException();
    }

    /**
     * @deprecated deprecated
     */
    @Deprecated
    @Override
    public String encodeRedirectUrl(final String url) {
        return encodeRedirectURL(url);
    }

    /**
     * @see javax.servlet.http.HttpServletResponse#encodeRedirectURL(java.lang.String)
     */
    @Override
    public String encodeRedirectURL(final String url) {
        return url;
    }

    /**
     * @deprecated deprecated
     */
    @Deprecated
    @Override
    public String encodeUrl(final String url) {
        return encodeURL(url);
    }

    /**
     * @see javax.servlet.http.HttpServletResponse#encodeURL(java.lang.String)
     */
    @Override
    public String encodeURL(final String url) {
        return url;
    }

    /**
     * @see javax.servlet.http.HttpServletResponse#sendError(int)
     */
    @Override
    public void sendError(final int status) {
        throw new UnsupportedOperationException();
    }

    /**
     * @see javax.servlet.http.HttpServletResponse#sendError(int, java.lang.String)
     */
    @Override
    public void sendError(final int status, final String message) {
        throw new UnsupportedOperationException();
    }

    /**
     * @see javax.servlet.http.HttpServletResponse#sendRedirect(java.lang.String)
     */
    @Override
    public void sendRedirect(final String location) {
        throw new UnsupportedOperationException();
    }

    /**
     * @see javax.servlet.http.HttpServletResponse#setDateHeader(java.lang.String, long)
     */
    @Override
    public void setDateHeader(final String name, final long value) {
        throw new UnsupportedOperationException();
    }

    /**
     * @see javax.servlet.http.HttpServletResponse#setHeader(java.lang.String, java.lang.String)
     */
    @Override
    public void setHeader(final String name, final String value) {
        throw new UnsupportedOperationException();
    }

    /**
     * @see javax.servlet.http.HttpServletResponse#setIntHeader(java.lang.String, int)
     */
    @Override
    public void setIntHeader(final String name, final int value) {
        throw new UnsupportedOperationException();
    }

    /**
     * @see javax.servlet.http.HttpServletResponse#setStatus(int)
     */
    @Override
    public void setStatus(final int status) {
        throw new UnsupportedOperationException();
    }

    /**
     * @deprecated deprecated
     */
    @Deprecated
    @Override
    public void setStatus(final int status, final String message) {
        throw new UnsupportedOperationException();
    }


    // ------------------------------------------------- ServletResponse Methods

    /**
     * @see javax.servlet.ServletResponse#flushBuffer()
     */
    @Override
    public void flushBuffer() {
        throw new UnsupportedOperationException();
    }

    /**
     * @see javax.servlet.ServletResponse#getBufferSize()
     */
    @Override
    public int getBufferSize() {
        throw new UnsupportedOperationException();
    }

    /**
     * @see javax.servlet.ServletResponse#getCharacterEncoding()
     */
    @Override
    public String getCharacterEncoding() {
        throw new UnsupportedOperationException();
    }

    /**
     * @see javax.servlet.ServletResponse#getContentType()
     */
    @Override
    public String getContentType() {
        throw new UnsupportedOperationException();
    }

    /**
     * @see javax.servlet.ServletResponse#getLocale()
     */
    @Override
    public Locale getLocale() {
        return this.locale;
    }

    /**
     * @see javax.servlet.ServletResponse#getOutputStream()
     */
    @Override
    public ServletOutputStream getOutputStream() throws IOException {
        throw new UnsupportedOperationException();
    }

    /**
     * @see javax.servlet.ServletResponse#getWriter()
     */
    @Override
    public PrintWriter getWriter() throws IOException {
        throw new UnsupportedOperationException();
    }

    /**
     * @see javax.servlet.ServletResponse#isCommitted()
     */
    @Override
    public boolean isCommitted() {
        throw new UnsupportedOperationException();
    }

    /**
     * @see javax.servlet.ServletResponse#reset()
     */
    @Override
    public void reset() {
        throw new UnsupportedOperationException();
    }

    /**
     * @see javax.servlet.ServletResponse#resetBuffer()
     */
    @Override
    public void resetBuffer() {
        throw new UnsupportedOperationException();
    }

    /**
     * @see javax.servlet.ServletResponse#setBufferSize(int)
     */
    @Override
    public void setBufferSize(final int size) {
        throw new UnsupportedOperationException();
    }

    /**
     * @see javax.servlet.ServletResponse#setCharacterEncoding(java.lang.String)
     */
    @Override
    public void setCharacterEncoding(final String encoding) {
        throw new UnsupportedOperationException();
    }

    /**
     * @see javax.servlet.ServletResponse#setContentLength(int)
     */
    @Override
    public void setContentLength(final int length) {
        throw new UnsupportedOperationException();
    }

    /**
     * @see javax.servlet.ServletResponse#setContentType(java.lang.String)
     */
    @Override
    public void setContentType(final String type) {
        throw new UnsupportedOperationException();
    }

    /**
     * @see javax.servlet.ServletResponse#setLocale(java.util.Locale)
     */
    @Override
    public void setLocale(final Locale val) {
        this.locale = val;
    }

    /**
     * @see javax.servlet.http.HttpServletResponse#getHeader(java.lang.String)
     */
    @Override
    public String getHeader(final String arg0) {
        return null;
    }

    /**
     * @see javax.servlet.http.HttpServletResponse#getHeaderNames()
     */
    @Override
    public Collection<String> getHeaderNames() {
        return null;
    }

    /**
     * @see javax.servlet.http.HttpServletResponse#getHeaders(java.lang.String)
     */
    @Override
    public Collection<String> getHeaders(final String arg0) {
        return null;
    }

    /**
     * @see javax.servlet.http.HttpServletResponse#getStatus()
     */
    @Override
    public int getStatus() {
        return 0;
    }

    /**
     * @see javax.servlet.ServletResponse#setContentLengthLong(long)
     */
    @Override
    public void setContentLengthLong(final long arg0) {
        return;
    }

}
