/*
 * $Id: ModuleException.java 471754 2006-11-06 14:55:09Z husted $
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.struts.util;

import org.apache.struts.action.ActionMessage;

/**
 * Used for specialized exception handling.
 */
public class ModuleException extends Exception {

    /** serialVersionUID */
    private static final long serialVersionUID = 623125126450529319L;

    /** property */
    private final String property;

    /**
     * The ActionMessage associated with this exception.
     *
     * @since Struts 1.2
     */
    private final ActionMessage message;

    /**
     * Construct an module exception with no replacement values.
     *
     * @param key Message key for this error message
     */
    public ModuleException(final String key) {
        this(null, key);
    }

    /**
     * Constructor
     *
     * @param prop property
     * @param key Message key for this message
     */
    public ModuleException(final String prop, final String key) {
        super(key);
        this.message = new ActionMessage(key);
        this.property = prop;
    }

    /**
     * Construct an error with the specified replacement values.
     *
     * @param key    Message key for this message
     * @param values Array of replacement values
     */
    public ModuleException(final String key, final Object... values) {
        this(null, key, values);
    }

    /**
     * Constructor
     *
     * @param prop property
     * @param key Message key for this message
     * @param values Array of replacement values
     */
    public ModuleException(final String prop, final String key, final Object... values) {
        super(key);
        this.message = new ActionMessage(key, values);
        this.property = prop;
    }

    /**
     * Returns the property associated with the exception.
     *
     * @return Value of property.
     */
    public String getProperty() {
        return (this.property != null) ? this.property : this.message.getKey();
    }

    /**
     * Returns the error associated with the exception.
     *
     * @return Value of property error.
     * @since Struts 1.2
     */
    public ActionMessage getActionMessage() {
        return this.message;
    }
}
