/*
 * $Id: CreateAction.java 510851 2007-02-23 07:05:18Z pbenedict $
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.struts.chain.commands.servlet;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.Action;
import org.apache.struts.chain.Constants;
import org.apache.struts.chain.commands.util.ClassUtils;
import org.apache.struts.chain.contexts.ActionContext;
import org.apache.struts.config.ActionConfig;
import org.apache.struts.config.ModuleConfig;

/**
 * <p>Concrete implementation of <code>AbstractCreateAction</code> for use in
 * a Servlet API chain.  Expects that the ActionContext passed into it can
 * safely be cast to <code>ServletActionContext</code>.</p>
 */
public class CreateAction extends org.apache.struts.chain.commands.AbstractCreateAction {

    // ------------------------------------------------------ Instance Variables

    private static final Log LOG = LogFactory.getLog(CreateAction.class);

    /**
     * @see org.apache.struts.chain.commands.AbstractCreateAction#getAction(
     * org.apache.struts.chain.contexts.ActionContext,
     * java.lang.String, org.apache.struts.config.ActionConfig)
     */
    @Override
    protected Action getAction(final ActionContext<String, Object> context, final String type,
            final ActionConfig actionConfig) {
        ModuleConfig moduleConfig = actionConfig.getModuleConfig();
        String actionsKey = Constants.ACTIONS_KEY + moduleConfig.getPrefix();

        ConcurrentMap<String, Action> actions =
                ClassUtils.cast(context.getApplicationScope().get(actionsKey));
        if (actions == null) {
            actions = getActions(context, actionsKey);
        }

        Action action = actions.get(type);
        if (action == null) {
            action = createAction(context, type);
            Action act = actions.putIfAbsent(type, action);
            if (act != null) {
                action = act;
            }
        }

        return action;
    }

    /**
     * <p>Invoked by <code>getAction</code> when the <code>Action</code>
     * actually has to be created. If the instance is already created and
     * cached, this method will not be called. </p>
     *
     * @param context      The <code>Context</code> for this request
     * @param type         Name of class to instantiate
     * @return Instantiated Action class
     * @throws RuntimeException if there are any problems instantiating the Action
     *                   class.
     * @since Struts 1.3.7
     */
    protected Action createAction(final ActionContext<String, Object> context, final String type) {
        LOG.info("Initialize action of type: " + type);

        return ClassUtils.getApplicationInstance(type);
    }

    protected synchronized ConcurrentMap<String, Action>
            getActions(final ActionContext<String, Object> context, final String key) {
        ConcurrentMap<String, Action> actions =
                ClassUtils.cast(context.getApplicationScope().get(key));
        if (actions == null) {
            actions = new ConcurrentHashMap<>();
            context.getApplicationScope().put(key, actions);
        }
        return actions;
    }
}
