/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.commons.chain2.testutils;


import org.apache.commons.chain2.Chain;
import org.apache.commons.chain2.Command;
import org.apache.commons.chain2.Context;
import org.apache.commons.chain2.Processing;


/**
 * Implementation of {@link Command} that always returns null if it's executed.
 *
 * @version $Id $
 */
public class NullReturningCommand extends DelegatingCommand {


    // ------------------------------------------------------------ Constructor

    /**
     * constructor
     */
    public NullReturningCommand() {
        this("");
    }


    /**
     * Construct an instance that will log the specified identifier
     * @param id String
     */
    public NullReturningCommand(final String id) {
        super(id);
    }


    // -------------------------------------------------------- Command Methods

    /**
     * @see org.apache.commons.chain2.testutils.DelegatingCommand
     * #execute(org.apache.commons.chain2.Context)
     */
    @Override
    public Processing execute(final Context<String, Object> context) {
        return null;
    }


    /**
     * @param context Context
     * @param chain Chain
     * @return Processing
     */
    public Processing execute(final Context<String, Object> context,
            final Chain<String, Object, Context<String, Object>> chain) {
        return null;
    }

}
