/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.commons.chain2.base;

import org.apache.commons.chain2.ChainException;
import org.apache.commons.chain2.Command;

import java.util.Map;

/**
 * Runtime Exception that wraps an underlying exception thrown during the
 * execution of a {@link org.apache.commons.chain2.Command}
 * or {@link org.apache.commons.chain2.Chain}.
 *
 * @version $Id$
 */
public class DispatchException extends ChainException {

    /** serialVersionUID */
    private static final long serialVersionUID = 20120724L;

    /**
     * @param message String
     */
    public DispatchException(final String message) {
        super(message);
    }

    /**
     * @param message String
     * @param cause Throwable
     */
    public DispatchException(final String message, final Throwable cause) {
        super(message, cause);
    }

    /**
     * @param <K> K
     * @param <V> V
     * @param <C> C
     * @param message String
     * @param cause Throwable
     * @param context C
     * @param failedCommand Command
     */
    public <K, V, C extends Map<K, V>> DispatchException(final String message,
            final Throwable cause, final C context, final Command<K, V, C> failedCommand) {
        super(message, cause, context, failedCommand);
    }

}
