package core.config;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

/**
 * Factoryテスト
 *
 * @author Tadashi Nakayama
 */
public class FactoryTest {

	/**
	 * テストインタフェース取得
	 *
	 * @param <T> ジェネリックス
	 * @param cls クラス
	 * @return テストインタフェース
	 */
	private <T> T getInterface(final Class<T> cls) {
		return Factory.create(cls);
	}

	/**
	 * インターフェースインスタンス化テスト
	 * デフォルトメソッド
	 */
	@Test
	@DisplayName("インターフェースインスタンス化テスト")
	public void testInterface() {
		final var ti = getInterface(TestInterface.class);
		Assertions.assertEquals("testMethod", ti.testMethod());
	}

	/**
	 * abstractクラスインスタンス化テスト
	 */
	@Test
	@DisplayName("abstractクラスインスタンス化テスト")
	public void testAbstract() {
		final var ta = getInterface(TestAbstract.class);
		Assertions.assertNull(ta);
	}

	/**
	 * インターフェースインスタンス化テスト
	 * デフォルトメソッドなし
	 */
	@Test
	@DisplayName("インターフェースインスタンス化テスト")
	public void testInterface2() {
		final var ti = getInterface(TestInterface2.class);
		Assertions.assertNull(ti.testMethod());
	}

	/**
	 * テストインタフェース
	 *
	 * @author tadashi
	 */
	public interface TestInterface {
		/**
		 * デフォルトメソッド
		 *
		 * @return 文字列
		 */
		default String testMethod() {
			System.out.println("testMethod");
			return "testMethod";
		}
	}

	/**
	 * abstractクラス
	 *
	 * @author tadashi
	 */
	public abstract class TestAbstract {
		/**
		 * テスト対象メソッド
		 *
		 * @return 文字列
		 */
		public String testMethod() {
			System.out.println("testMethodA");
			return "testMethodA";
		}
	}

	/**
	 * テストインターフェース
	 *
	 * @author tadashi
	 */
	public interface TestInterface2 {
		/**
		 * テスト対象メソッド
		 *
		 * @return 文字列
		 */
		String testMethod();
	}
}
