package core.file;

import java.io.FilterOutputStream;
import java.io.OutputStream;

/**
 * クローズなしOutputStream
 *
 * @author Tadashi Nakayama
 */
public class NoCloseOutputStream extends FilterOutputStream {

	/**
	 * コンストラクタ
	 *
	 * @param val OutputStream
	 */
	public NoCloseOutputStream(final OutputStream val) {
		super(val);
	}

	/**
	 * @see java.io.FilterOutputStream#close()
	 */
	@Override
	public void close() {
		return;
	}
}
