package common.sql;

import java.util.List;
import java.util.Map;

/**
 * パース通常文字列保持
 *
 * @author Tadashi Nakayama
 */
final class LineParsedNodeString implements LineParsedNode {

	/** クエリ */
	private final String query;

	/**
	 * コンストラクタ
	 *
	 * @param val クエリ
	 */
	LineParsedNodeString(final String val) {
		this.query = val;
	}

	/**
	 * クエリ構築
	 *
	 * @param map パラメタマップ
	 * @param list パラメタリスト
	 * @return クエリ
	 */
	@Override
	public String build(final Map<String, ?> map, final List<Object> list) {
		return this.query;
	}

	/**
	 * ターゲット判断
	 *
	 * @param pmap パラメタマップ
	 * @return ターゲットの場合 true を返す。
	 */
	@Override
	public boolean isTarget(final Map<String, ?> pmap) {
		return true;
	}
}
