package batch.base;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;

import core.util.bean.Pair;

/**
 * バッチ作成親
 *
 * @author Tadashi Nakayama
 */
public abstract class BaseBatch implements Batch {

	/** 作成ファイルリスト */
	private final CopyOnWriteArrayList<Pair<String, String>> fileList =
					new CopyOnWriteArrayList<>();

	/** メッセージテキスト */
	private String message = null;

	/**
	 * メッセージ取得
	 *
	 * @return メッセージ
	 */
	@Override
	public String getMessage() {
		return this.message;
	}

	/**
	 * メッセージ設定
	 *
	 * @param val メッセージ
	 */
	public void setMessage(final String val) {
		this.message = val;
	}

	/**
	 * ファイルリスト取得
	 *
	 * @return ファイルリスト
	 */
	@Override
	public List<Pair<String, String>> getOutputFiles() {
		return Collections.unmodifiableList(this.fileList);
	}

	/**
	 * ファイル設定
	 *
	 * @param file ファイル名（フルパス）
	 * @param download ダウンロード名
	 */
	protected void addFile(final String file, final String download) {
		if (Objects.toString(download, "").trim().isEmpty()) {
			this.fileList.add(Pair.of(file, null));
		} else {
			this.fileList.add(Pair.of(file, download));
		}
	}
}
