CREATE TABLE FW_JOB_INFO
(
  JOB_ID               VARCHAR2(32)    NOT NULL,
  MULTIPLICITY         NUMBER(2)       NOT NULL,
  CANCEL_TYPE          CHAR(1)         NOT NULL,
  RUNNABLE_BEGIN_HHMM  CHAR(4),
  RUNNABLE_END_HHMM    CHAR(4)
)
;

ALTER TABLE FW_JOB_INFO ADD CONSTRAINT FW_JOB_INFO_PK PRIMARY KEY
(
  JOB_ID
)
;

COMMENT ON TABLE FW_JOB_INFO IS 'ジョブ情報';
COMMENT ON COLUMN FW_JOB_INFO.JOB_ID IS 'ジョブID';
COMMENT ON COLUMN FW_JOB_INFO.MULTIPLICITY IS '多重度';
COMMENT ON COLUMN FW_JOB_INFO.CANCEL_TYPE IS 'キャンセル可能';
COMMENT ON COLUMN FW_JOB_INFO.RUNNABLE_BEGIN_HHMM IS '実行可能開始時間';
COMMENT ON COLUMN FW_JOB_INFO.RUNNABLE_END_HHMM IS '実行可能終了時間';
