package project.db.model;

import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * FwJobFile generated by hbm2java
 */
@org.hibernate.annotations.DynamicInsert
@Entity
@Table(name = "fw_job_file")
public class FwJobFile implements java.io.Serializable {

	private FwJobFileId id;
	private String fileName;
	private String filePath;
	private Long fileSize;
	private String downloadName;
	private int downloadCount;

	public FwJobFile() {
	}

	public FwJobFile(FwJobFileId id, String fileName, int downloadCount) {
		this.id = id;
		this.fileName = fileName;
		this.downloadCount = downloadCount;
	}

	public FwJobFile(FwJobFileId id, String fileName, String filePath,
			Long fileSize, String downloadName, int downloadCount) {
		this.id = id;
		this.fileName = fileName;
		this.filePath = filePath;
		this.fileSize = fileSize;
		this.downloadName = downloadName;
		this.downloadCount = downloadCount;
	}

	@EmbeddedId
	@AttributeOverrides({
			@AttributeOverride(name = "jobSeq", column = @Column(name = "job_seq", nullable = false)),
			@AttributeOverride(name = "batSeq", column = @Column(name = "bat_seq", nullable = false)),
			@AttributeOverride(name = "fileSeq", column = @Column(name = "file_seq", nullable = false)) })
	public FwJobFileId getId() {
		return this.id;
	}

	public void setId(FwJobFileId id) {
		this.id = id;
	}

	@Column(name = "file_name", nullable = false, length = 128)
	public String getFileName() {
		return this.fileName;
	}

	public void setFileName(String fileName) {
		this.fileName = fileName;
	}

	@Column(name = "file_path", length = 256)
	public String getFilePath() {
		return this.filePath;
	}

	public void setFilePath(String filePath) {
		this.filePath = filePath;
	}

	@Column(name = "file_size")
	public Long getFileSize() {
		return this.fileSize;
	}

	public void setFileSize(Long fileSize) {
		this.fileSize = fileSize;
	}

	@Column(name = "download_name", length = 128)
	public String getDownloadName() {
		return this.downloadName;
	}

	public void setDownloadName(String downloadName) {
		this.downloadName = downloadName;
	}

	@Column(name = "download_count", nullable = false)
	public int getDownloadCount() {
		return this.downloadCount;
	}

	public void setDownloadCount(int downloadCount) {
		this.downloadCount = downloadCount;
	}

}
