/*
 * $Id: MockHttpServletResponse.java 471754 2006-11-06 14:55:09Z husted $
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.struts.mock;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Locale;

/**
 * <p>Mock <strong>HttpServletResponse</strong> object for low-level unit
 * tests of Struts controller components.  Coarser grained tests should be
 * implemented in terms of the Cactus framework, instead of the mock object
 * classes.</p>
 *
 * <p><strong>WARNING</strong> - Only the minimal set of methods needed to
 * create unit tests is provided, plus additional methods to configure this
 * object as necessary.  Methods for unsupported operations will throw
 * <code>UnsupportedOperationException</code>.</p>
 *
 * <p><strong>WARNING</strong> - Because unit tests operate in a single
 * threaded environment, no synchronization is performed.</p>
 *
 * @version $Rev: 471754 $ $Date: 2005-05-07 12:11:38 -0400 (Sat, 07 May 2005)
 *          $
 */
public class MockHttpServletResponse implements HttpServletResponse {
    // ----------------------------------------------------- Instance Variables
    // --------------------------------------------------------- Public Methods
    // -------------------------------------------- HttpServletResponse Methods
    /** @see javax.servlet.http.HttpServletResponse#addCookie(javax.servlet.http.Cookie) */
    @Override public void addCookie(Cookie cookie) {
        throw new UnsupportedOperationException();
    }
    /** @see javax.servlet.http.HttpServletResponse#addDateHeader(java.lang.String, long) */
    @Override public void addDateHeader(String name, long value) {
        throw new UnsupportedOperationException();
    }
    /** @see javax.servlet.http.HttpServletResponse#addHeader(java.lang.String, java.lang.String) */
    @Override public void addHeader(String name, String value) {
        throw new UnsupportedOperationException();
    }
    /** @see javax.servlet.http.HttpServletResponse#addIntHeader(java.lang.String, int) */
    @Override public void addIntHeader(String name, int value) {
        throw new UnsupportedOperationException();
    }
    /** @see javax.servlet.http.HttpServletResponse#containsHeader(java.lang.String) */
    @Override public boolean containsHeader(String name) {
        throw new UnsupportedOperationException();
    }
    /** @see javax.servlet.http.HttpServletResponse#encodeRedirectUrl(java.lang.String) */
    @Override public String encodeRedirectUrl(String url) {
        return (encodeRedirectURL(url));
    }
    /** @see javax.servlet.http.HttpServletResponse#encodeRedirectURL(java.lang.String) */
    @Override public String encodeRedirectURL(String url) {
        return (url);
    }
    /** @see javax.servlet.http.HttpServletResponse#encodeUrl(java.lang.String) */
    @Override public String encodeUrl(String url) {
        return (encodeURL(url));
    }
    /** @see javax.servlet.http.HttpServletResponse#encodeURL(java.lang.String) */
    @Override public String encodeURL(String url) {
        return (url);
    }
    /** @see javax.servlet.http.HttpServletResponse#sendError(int) */
    @Override public void sendError(int status) {
        throw new UnsupportedOperationException();
    }
    /** @see javax.servlet.http.HttpServletResponse#sendError(int, java.lang.String) */
    @Override public void sendError(int status, String message) {
        throw new UnsupportedOperationException();
    }
    /** @see javax.servlet.http.HttpServletResponse#sendRedirect(java.lang.String) */
    @Override public void sendRedirect(String location) {
        throw new UnsupportedOperationException();
    }
    /** @see javax.servlet.http.HttpServletResponse#setDateHeader(java.lang.String, long) */
    @Override public void setDateHeader(String name, long value) {
        throw new UnsupportedOperationException();
    }
    /** @see javax.servlet.http.HttpServletResponse#setHeader(java.lang.String, java.lang.String) */
    @Override public void setHeader(String name, String value) {
        throw new UnsupportedOperationException();
    }
    /** @see javax.servlet.http.HttpServletResponse#setIntHeader(java.lang.String, int) */
    @Override public void setIntHeader(String name, int value) {
        throw new UnsupportedOperationException();
    }
    /** @see javax.servlet.http.HttpServletResponse#setStatus(int) */
    @Override public void setStatus(int status) {
        throw new UnsupportedOperationException();
    }
    /** @see javax.servlet.http.HttpServletResponse#setStatus(int, java.lang.String) */
    @Override public void setStatus(int status, String message) {
        throw new UnsupportedOperationException();
    }
    // ------------------------------------------------ ServletResponse Methods
    /** @see javax.servlet.ServletResponse#flushBuffer() */
    @Override public void flushBuffer() {
        throw new UnsupportedOperationException();
    }
    /** @see javax.servlet.ServletResponse#getBufferSize() */
    @Override public int getBufferSize() {
        throw new UnsupportedOperationException();
    }
    /** @see javax.servlet.ServletResponse#getCharacterEncoding() */
    @Override public String getCharacterEncoding() {
        throw new UnsupportedOperationException();
    }
    /** @see javax.servlet.ServletResponse#getLocale() */
    @Override public Locale getLocale() {
        throw new UnsupportedOperationException();
    }
    /** @see javax.servlet.ServletResponse#getOutputStream() */
    @Override public ServletOutputStream getOutputStream()
        throws IOException {
        throw new UnsupportedOperationException();
    }
    /** @see javax.servlet.ServletResponse#getWriter() */
    @Override public PrintWriter getWriter()
        throws IOException {
        throw new UnsupportedOperationException();
    }
    /** @see javax.servlet.ServletResponse#isCommitted() */
    @Override public boolean isCommitted() {
        throw new UnsupportedOperationException();
    }
    /** @see javax.servlet.ServletResponse#reset() */
    @Override public void reset() {
        throw new UnsupportedOperationException();
    }
    /** @see javax.servlet.ServletResponse#resetBuffer() */
    @Override public void resetBuffer() {
        throw new UnsupportedOperationException();
    }
    /** @see javax.servlet.ServletResponse#setBufferSize(int) */
    @Override public void setBufferSize(int size) {
        throw new UnsupportedOperationException();
    }
    /** @see javax.servlet.ServletResponse#setContentLength(int) */
    @Override public void setContentLength(int length) {
        throw new UnsupportedOperationException();
    }
    /** @see javax.servlet.ServletResponse#setContentType(java.lang.String) */
    @Override public void setContentType(String type) {
        throw new UnsupportedOperationException();
    }
    /** @see javax.servlet.ServletResponse#setLocale(java.util.Locale) */
    @Override public void setLocale(Locale locale) {
        throw new UnsupportedOperationException();
    }
    /** @see javax.servlet.ServletResponse#getContentType() */
    @Override
    public String getContentType() {
        return null;
    }
    /** @see javax.servlet.ServletResponse#setCharacterEncoding(java.lang.String) */
    @Override
    public void setCharacterEncoding(String arg0) {
        return;
    }
    /** @see javax.servlet.http.HttpServletResponse#getHeader(java.lang.String) */
    @Override
    public String getHeader(String arg0) {
        return null;
    }
    /** @see javax.servlet.http.HttpServletResponse#getHeaderNames() */
    @Override
    public Collection<String> getHeaderNames() {
        return null;
    }
    /** @see javax.servlet.http.HttpServletResponse#getHeaders(java.lang.String) */
    @Override
    public Collection<String> getHeaders(String arg0) {
        return null;
    }
    /** @see javax.servlet.http.HttpServletResponse#getStatus() */
    @Override
    public int getStatus() {
        return 0;
    }
    /**
     * @see javax.servlet.ServletResponse#setContentLengthLong(long)
     */
    @Override
    public void setContentLengthLong(long arg0) {
        return;
    }
}
