package test;

import org.junit.Assert;

/**
 * AssertUtil
 *
 */
public final class AssertUtil {

	/**
	 * Constructor
	 */
	private AssertUtil() {
		throw new AssertionError();
	}

	/**
	 * assertEquals
	 * @param expected boolean
	 * @param actual boolean
	 */
	public static void assertEquals(final boolean expected, final boolean actual) {
		Assert.assertEquals(Boolean.valueOf(expected), Boolean.valueOf(actual));
	}

	/**
	 * assertEquals
	 * @param message String
	 * @param expected boolean
	 * @param actual boolean
	 */
	public static void assertEquals(final String message,
			final boolean expected, final boolean actual) {
		Assert.assertEquals(message, Boolean.valueOf(expected), Boolean.valueOf(actual));
	}
}
