package project.common;

import org.junit.Assert;
import org.junit.Test;

/**
 * TestCsvUtil
 *
 */
public class TestCsvUtil {

	/**
	 * CSV文字列カンマ含む改行CRLF終了配列化
	 */
	@Test
	public void toArrayTest1() {
		final String[] vals = CsvUtil.toArray(",aaa,\"bbbb,\"\r\n");
		Assert.assertEquals(3, vals.length);
		Assert.assertEquals("", vals[0]);
		Assert.assertEquals("aaa", vals[1]);
		Assert.assertEquals("bbbb,", vals[2]);
	}

	/**
	 * 文字列配列改行CRありCSV文字列化
	 */
	@Test
	public void toCsvTest1() {
		final String val = CsvUtil.toCsv("aaaa", ",", "aaa\r\nbbb", "\"ddd");
		Assert.assertEquals("aaaa,\",\",\"aaa\nbbb\",\"\"\"ddd\"", val);
	}

	/**
	 * 文字列配列改行LFありCSV文字列化
	 */
	@Test
	public void toCsvTest2() {
		final String val = CsvUtil.toCsv("aaaa", ",", "aaa\nbbb", "\"ddd");
		Assert.assertEquals("aaaa,\",\",\"aaa\nbbb\",\"\"\"ddd\"", val);
	}

	/**
	 * CSV文字列配列化改行CRダブルクォートあり
	 */
	public void toArrayTest2() {
		final String[] vals = CsvUtil.toArray("aaaa,\",\",\"aaa\r\nbbb\",\"\"\"ddd\"\r\n");
		Assert.assertEquals(4, vals.length);
		Assert.assertEquals("aaaa", vals[0]);
		Assert.assertEquals(",", vals[1]);
		Assert.assertEquals("aaa\r\nbbb", vals[2]);
		Assert.assertEquals("\"ddd", vals[3]);
	}

	/**
	 * CSV文字列配列化改行LFダブルクォートあり
	 */
	@Test
	public void toArrayTest3() {
		final String[] vals = CsvUtil.toArray("aaaa,\",\",\"aaa\nbbb\",\"\"\"ddd\"\r\n");
		Assert.assertEquals(4, vals.length);
		Assert.assertEquals("aaaa", vals[0]);
		Assert.assertEquals(",", vals[1]);
		Assert.assertEquals("aaa\nbbb", vals[2]);
		Assert.assertEquals("\"ddd", vals[3]);
	}

	/**
	 * CSV文字列配列化カンマ終了
	 */
	@Test
	public void toArrayTest4() {
		final String[] vals = CsvUtil.toArray("1,");
		Assert.assertEquals(2, vals.length);
		Assert.assertEquals("1", vals[0]);
		Assert.assertEquals("", vals[1]);
	}
}
