package project.web.processor;

import org.apache.commons.chain2.Processing;
import org.apache.struts.action.ActionForward;
import org.apache.struts.chain.contexts.ServletActionContext;

import core.config.Factory;
import online.struts.action.ActionProxy;
import online.struts.action.PerformAction;
import online.struts.action.UniForm;
import online.struts.chain.command.RequestCommand;
import online.struts.mapping.RequestMapping;
import project.master.MsgUtil;
import project.web.auth.LogonAction;

/**
 * ログオンコマンド
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public final class LogonProcessor implements RequestCommand {

	/**
	 * @see online.struts.chain.command.RequestCommand
	 * #command(org.apache.struts.chain.contexts.ServletActionContext,
	 * online.struts.mapping.RequestMapping, online.struts.action.UniForm)
	 */
	@Override
	public Processing command(final ServletActionContext sac,
			final RequestMapping mapping, final UniForm uf) {
		// ログオン処理
		final LogonAction la = Factory.create(LogonAction.class);
		if (la != null) {
			final ActionProxy proxy = new ActionProxy(la);
			final ActionForward af = proxy.execute(
					mapping, uf, sac.getRequest(), sac.getResponse());
			if (af != null && PerformAction.ID_OK.equals(af.getName())) {
				sac.setForwardConfig(null);
				MsgUtil.removeTopMessage(uf);
			}
		}
		return Processing.CONTINUE;
	}
}
