package common.db.dao.hibernate;

import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;

/**
 * 環境保持
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
final class Config {
	/** Configuration */
	private final Configuration configuration;
	/** SessionFactory */
	private final SessionFactory factory;
	/** Dialect */
	private final Dialect dialect;

	/**
	 * コンストラクタ
	 * @param cfg Configuration
	 * @param sf SessionFactory
	 */
	Config(final Configuration cfg, final SessionFactory sf) {
		this.configuration = cfg;
		this.factory = sf;
		this.dialect = Dialect.getDialect(this.configuration.getProperties());
	}

	/**
	 * Configuration取得
	 * @return Configuration
	 */
	public Configuration getConfiguration() {
		return this.configuration;
	}

	/**
	 * SessionFactory取得
	 * @return SessionFactory
	 */
	public SessionFactory getSessionFactory() {
		return this.factory;
	}

	/**
	 * Dialect取得
	 * @return Dialect
	 */
	public Dialect getDialect() {
		return this.dialect;
	}
}
