package project.common.db;

import java.util.Map;

/**
 * DBメタ情報保持
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public interface DBMetaData {

	/**
	 * テーブルコメント取得
	 * @param table テーブル名
	 * @return テーブルコメント
	 */
	String getTableComment(String table);

	/**
	 * テーブルコメント取得
	 * @param table テーブル名
	 * @param name 接続名
	 * @return テーブルコメント
	 */
	String getTableComment(String table, String name);

	/**
	 * テーブル情報取得
	 *
	 * @param table テーブル名
	 * @return テーブル情報
	 */
	Map<String, DBColumnInfo> getColumnInfo(String table);

	/**
	 * テーブル情報取得
	 *
	 * @param table テーブル名
	 * @param name 接続名
	 * @return テーブル情報
	 */
	Map<String, DBColumnInfo> getColumnInfo(String table, String name);
}
