package project.batch.jasper;

import java.sql.ResultSet;

import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRResultSetDataSource;

/**
 * 拡張JasperReportデータソース
 * @author Tadashi Nakayama
 */
public final class JRResultSetDataSourceEx extends JRResultSetDataSource {

	/** 開始フラグ */
	private boolean first = true;
	/** レコード存在フラグ */
	private boolean hasRecord = false;

	/**
	 * コンストラクタ
	 * @param rs ResultSet
	 */
	public JRResultSetDataSourceEx(final ResultSet rs) {
		super(rs);
		try {
			this.hasRecord = super.next();
		} catch (final JRException e) {
			throw new RuntimeException(e);
		}
	}

	/**
	 * 次レコード移動
	 */
	@Override
	public boolean next() throws JRException {
		if (this.first) {
			this.first = false;
			return this.hasRecord;
		}
		return super.next();
	}

	/**
	 * カウント取得
	 * @return カウント
	 */
	public boolean hasRecord() {
		return this.hasRecord;
	}
}
