package online.view.tag;

import javax.servlet.jsp.JspException;

/**
 * ステータス設定タグ
 *
 * @author Tadashi Nakayama
 */
public class StatusTag extends BaseTag {

	/** serialVersionUID */
	private static final long serialVersionUID = 7532049530551078496L;

	/** ステータス */
	private int status;

	/**
	 * ステータス設定
	 * @param val ステータス
	 */
	public void setStatus(final int val) {
		this.status = val;
	}

	/**
	 * @see javax.servlet.jsp.tagext.TagSupport#doStartTag()
	 */
	@Override
	public int doStartTag() throws JspException {
		if (super.getResponse().getStatus() == 0) {
			super.getResponse().setStatus(this.status);
		}
		return SKIP_BODY;
	}
}
