package online.listener;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.jsp.JspApplicationContext;
import javax.servlet.jsp.JspFactory;

import online.view.el.ViewELResolver;

/**
 * ELResolver登録リスナ
 *
 * @author Tadashi Nakayama
 */
public class ELServletContextListener implements ServletContextListener {

	/**
	 * @see javax.servlet.ServletContextListener#contextDestroyed(javax.servlet.ServletContextEvent)
	 */
	@Override
	public void contextDestroyed(final ServletContextEvent event) {
		return;
	}

	/**
	 * @see javax.servlet.ServletContextListener
	 * #contextInitialized(javax.servlet.ServletContextEvent)
	 */
	@Override
	public void contextInitialized(final ServletContextEvent event) {
		final JspApplicationContext jc = JspFactory.getDefaultFactory().getJspApplicationContext(
						event.getServletContext());
		jc.addELResolver(new ViewELResolver());
	}
}
