package online.context.check;

import java.nio.charset.Charset;
import java.util.function.Consumer;
import java.util.function.Predicate;

import core.exception.LogicalException;
import online.context.ActionParameter;
import online.context.session.SessionUser;
import online.model.UniModel;

/**
 * 入力チェック
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public interface InputCheck {

	/**
	 * 汎用モデル設定
	 *
	 * @param model 汎用モデル
	 */
	void setUniModel(UniModel model);

	/**
	 * アクションパラメタ設定
	 *
	 * @param param アクションパラメタ
	 */
	void setActionParameter(ActionParameter param);

	/**
	 * セションユーザ情報設定
	 *
	 * @param user セションユーザ情報
	 */
	void setSessionUser(SessionUser user);

	/**
	 * チェック対象判断設定
	 *
	 * @param predicate チェック対象判断
	 */
	void setPredicate(Predicate<Integer> predicate);

	/**
	 * エラー発生時実行
	 *
	 * @param ic 実行クラス
	 */
	void onError(Consumer<LogicalException> ic);

	/**
	 * 入力チェック設定
	 *
	 * @param item 項目名
	 * @param ic チェッククラス
	 */
	void add(String item, ItemCheck... ic);

	/**
	 * 入力チェック設定
	 *
	 * @param ic チェッククラス
	 * @param items 項目名
	 */
	void add(ItemCheck ic, String... items);

	/**
	 * 初期化
	 *
	 */
	void clear();

	/**
	 * チェック処理
	 */
	void check();

	/**
	 * チェック後入力値取込処理
	 */
	void populate();

	/**
	 * チェックマッピング設定
	 *
	 * @param val チェックマッピング
	 */
	void setMapping(Charset val);
}
