package common.transaction;


/**
 * ユーザトランザクション
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public interface XATransaction {

	/**
	 * トランザクション中確認
	 *
	 * @return トランザクション時 true を返す。
	 */
	boolean isInTransaction();

	/**
	 * トランザクション開始
	 *
	 */
	void beginTransaction();

	/**
	 * トランザクション終了
	 *
	 */
	void endTransaction();

	/**
	 * コミット処理
	 *
	 * @return コミット時 true を返す。
	 */
	boolean commit();

	/**
	 * ステータス取得
	 *
	 * @return ステータス
	 */
	int getStatus();

	/**
	 * リトライ判定
	 *
	 * @return リトライ時 true を返す。
	 */
	boolean mayRetry();
}
