/*
 * Decompiled with CFR 0.152.
 */
package jdd.zdd;

import jdd.bdd.OptimizedCache;
import jdd.util.Configuration;
import jdd.util.Test;
import jdd.util.math.Digits;
import jdd.zdd.ZDD;

public class ZDDGraph
extends ZDD {
    protected static final int CACHE_NOSUBSET = 0;
    protected static final int CACHE_NOSUPSET = 1;
    protected OptimizedCache graph_cache;

    public ZDDGraph(int n, int n2) {
        super(n, n2);
        this.graph_cache = new OptimizedCache("graph", n2 / Configuration.zddGraphCacheDiv, 3, 2);
    }

    @Override
    public void cleanup() {
        super.cleanup();
        this.graph_cache = null;
    }

    @Override
    protected void post_removal_callbak() {
        super.post_removal_callbak();
        this.graph_cache.free_or_grow(this);
    }

    public int allEdge() {
        return this.allEdge(0, this.num_vars - 1);
    }

    public int allEdge(int n, int n2) {
        int n3;
        if (n2 < n) {
            return 0;
        }
        int n4 = 0;
        int n5 = this.mk(n, 0, 1);
        this.work_stack[this.work_stack_tos++] = n4;
        this.work_stack[this.work_stack_tos++] = n5;
        for (n3 = n + 1; n3 < n2; ++n3) {
            int n6 = this.mk(n3, n4, n5);
            this.work_stack[this.work_stack_tos++] = n6;
            int n7 = n6;
            int n8 = this.mk(n3, n5, 1);
            this.work_stack[this.work_stack_tos++] = n8;
            int n9 = n8;
            this.work_stack_tos -= 4;
            int n10 = n7;
            this.work_stack[this.work_stack_tos++] = n10;
            n4 = n10;
            int n11 = n9;
            this.work_stack[this.work_stack_tos++] = n11;
            n5 = n11;
        }
        n3 = this.mk(n2, n4, n5);
        this.work_stack_tos -= 2;
        return n3;
    }

    public final int noSubset(int n, int n2) {
        int n3;
        int n4;
        if (n == n2 || n == 1 || n == 0) {
            return 0;
        }
        if (n2 == 0) {
            return n;
        }
        if (n2 == 1) {
            return this.diff(n, 1);
        }
        if (this.graph_cache.lookup(n, n2, 0)) {
            return this.graph_cache.answer;
        }
        int n5 = this.graph_cache.hash_value;
        int n6 = this.getVar(n);
        if (n6 > (n4 = this.getVar(n2))) {
            int n7 = this.noSubset(this.getLow(n), n2);
            this.work_stack[this.work_stack_tos++] = n7;
            int n8 = n7;
            n3 = this.mk(n6, n8, this.getHigh(n));
            --this.work_stack_tos;
        } else if (n6 < n4) {
            int n9 = this.noSubset(n, this.getLow(n2));
            this.work_stack[this.work_stack_tos++] = n9;
            int n10 = n9;
            int n11 = this.noSubset(n, this.getHigh(n2));
            this.work_stack[this.work_stack_tos++] = n11;
            int n12 = n11;
            n3 = this.intersect(n10, n12);
            this.work_stack_tos -= 2;
        } else {
            int n13 = this.noSubset(this.getLow(n), this.getLow(n2));
            this.work_stack[this.work_stack_tos++] = n13;
            int n14 = n13;
            int n15 = this.noSubset(this.getLow(n), this.getHigh(n2));
            this.work_stack[this.work_stack_tos++] = n15;
            int n16 = n15;
            n14 = this.intersect(n14, n16);
            this.work_stack_tos -= 2;
            this.work_stack[this.work_stack_tos++] = n14;
            int n17 = this.noSubset(this.getHigh(n), this.getHigh(n2));
            this.work_stack[this.work_stack_tos++] = n17;
            n16 = n17;
            n3 = this.mk(n6, n14, n16);
            this.work_stack_tos -= 2;
        }
        this.graph_cache.insert(n5, n, n2, 0, n3);
        return n3;
    }

    public int noSupset(int n, int n2) {
        if (this.emptyIn(n2)) {
            return 0;
        }
        return this.noSupset_rec(n, n2);
    }

    private final int noSupset_rec(int n, int n2) {
        int n3;
        int n4;
        if (n == 0 || n2 == 1 || n == n2) {
            return 0;
        }
        if (n == 1 || n2 == 0) {
            return n;
        }
        if (this.graph_cache.lookup(n, n2, 1)) {
            return this.graph_cache.answer;
        }
        int n5 = this.graph_cache.hash_value;
        int n6 = this.getVar(n);
        if (n6 < (n4 = this.getVar(n2))) {
            n3 = this.noSupset_rec(n, this.getLow(n2));
        } else if (n6 > n4) {
            int n7 = this.noSupset_rec(this.getHigh(n), n2);
            this.work_stack[this.work_stack_tos++] = n7;
            int n8 = n7;
            int n9 = this.noSupset_rec(this.getLow(n), n2);
            this.work_stack[this.work_stack_tos++] = n9;
            int n10 = n9;
            n3 = this.mk(n6, n10, n8);
            this.work_stack_tos -= 2;
        } else {
            int n11;
            int n12;
            int n13 = this.getHigh(n2);
            if (this.emptyIn(n13)) {
                n12 = 0;
                this.work_stack[this.work_stack_tos++] = 0;
            } else {
                int n14 = this.noSupset_rec(this.getHigh(n), this.getLow(n2));
                this.work_stack[this.work_stack_tos++] = n14;
                n12 = n14;
                int n15 = this.noSupset_rec(this.getHigh(n), n13);
                this.work_stack[this.work_stack_tos++] = n15;
                n11 = n15;
                n12 = this.intersect(n12, n11);
                this.work_stack_tos -= 2;
                this.work_stack[this.work_stack_tos++] = n12;
            }
            int n16 = this.noSupset_rec(this.getLow(n), this.getLow(n2));
            this.work_stack[this.work_stack_tos++] = n16;
            n11 = n16;
            n3 = this.mk(n6, n11, n12);
            this.work_stack_tos -= 2;
        }
        this.graph_cache.insert(n5, n, n2, 1, n3);
        return n3;
    }

    public int maxSet(int n) {
        if (n < 2) {
            return n;
        }
        int n2 = this.maxSet(this.getLow(n));
        this.work_stack[this.work_stack_tos++] = n2;
        int n3 = n2;
        int n4 = this.maxSet(this.getHigh(n));
        this.work_stack[this.work_stack_tos++] = n4;
        int n5 = n4;
        int n6 = this.noSubset(n3, n5);
        this.work_stack[this.work_stack_tos++] = n6;
        int n7 = n6;
        n3 = this.mk(this.getVar(n), n7, n5);
        this.work_stack_tos -= 3;
        return n3;
    }

    public int MaxDot(int n, int n2) {
        if (n < 2) {
            return n;
        }
        if (n2 < 2) {
            return n2;
        }
        int n3 = Math.max(this.getVar(n), this.getVar(n2));
        int n4 = this.subset1(n, n3);
        this.work_stack[this.work_stack_tos++] = n4;
        int n5 = n4;
        int n6 = this.subset1(n2, n3);
        this.work_stack[this.work_stack_tos++] = n6;
        int n7 = n6;
        int n8 = this.subset0(n, n3);
        this.work_stack[this.work_stack_tos++] = n8;
        int n9 = n8;
        int n10 = this.subset0(n2, n3);
        this.work_stack[this.work_stack_tos++] = n10;
        int n11 = n10;
        return 0;
    }

    public static void internal_test() {
        Test.start("ZDDGraph");
        ZDDGraph zDDGraph = new ZDDGraph(2000, 10000);
        int n = zDDGraph.createVar();
        int n2 = zDDGraph.createVar();
        int n3 = zDDGraph.createVar();
        int n4 = zDDGraph.createVar();
        int n5 = zDDGraph.createVar();
        int n6 = zDDGraph.cubes_union("00011 00010 00110");
        int n7 = zDDGraph.cubes_union("00011 00010 10011 00101");
        int n8 = zDDGraph.cubes_union("00011 00111 01110");
        int n9 = zDDGraph.cubes_union("00110 00111");
        int n10 = zDDGraph.noSubset(n6, n7);
        int n11 = zDDGraph.noSubset(n7, n6);
        int n12 = zDDGraph.noSubset(n8, n9);
        int n13 = zDDGraph.noSubset(n9, n8);
        int n14 = zDDGraph.cube("00110");
        int n15 = zDDGraph.cubes_union("00101 10011");
        int n16 = zDDGraph.cube("01110");
        int n17 = 0;
        Test.checkEquality(n10, n14, "noSubset(X,Y)");
        Test.checkEquality(n11, n15, "noSubset(Y,X)");
        Test.checkEquality(n12, n16, "noSubset(P,Q)");
        Test.checkEquality(n13, n17, "noSubset(Q,P)");
        Test.checkEquality(zDDGraph.work_stack_tos, 0, "work_stack_tos restored (1)");
        int n18 = zDDGraph.noSupset(n6, n7);
        int n19 = zDDGraph.noSupset(n7, n6);
        int n20 = zDDGraph.noSupset(n8, n9);
        int n21 = zDDGraph.noSupset(n9, n8);
        int n22 = 0;
        int n23 = zDDGraph.cube("00101");
        int n24 = zDDGraph.cube("00011");
        int n25 = zDDGraph.cube("00110");
        Test.checkEquality(n18, n22, "noSupset(X,Y)");
        Test.checkEquality(n19, n23, "noSupset(Y,X)");
        Test.checkEquality(n20, n24, "noSupset(P,Q)");
        Test.checkEquality(n21, n25, "noSupset(Q,P)");
        Test.checkEquality(zDDGraph.work_stack_tos, 0, "work_stack_tos restored (2)");
        int n26 = zDDGraph.maxSet(n6);
        int n27 = zDDGraph.maxSet(n7);
        Test.checkEquality(n26, zDDGraph.union(zDDGraph.cube("11"), zDDGraph.cube("110")), "maxSet (1)");
        Test.checkEquality(n27, zDDGraph.union(zDDGraph.cube("10011"), zDDGraph.cube("101")), "maxett (2)");
        Test.checkEquality(zDDGraph.work_stack_tos, 0, "work_stack_tos restored (3)");
        Test.checkEquality(zDDGraph.count(zDDGraph.allEdge(n, n2)), Digits.maxUniquePairs(n2 - n + 1), "allEdge(1)");
        Test.checkEquality(zDDGraph.count(zDDGraph.allEdge(n, n3)), Digits.maxUniquePairs(n3 - n + 1), "allEdge(2)");
        Test.checkEquality(zDDGraph.count(zDDGraph.allEdge(n, n4)), Digits.maxUniquePairs(n4 - n + 1), "allEdge(3)");
        Test.checkEquality(zDDGraph.count(zDDGraph.allEdge(n, n5)), Digits.maxUniquePairs(n5 - n + 1), "allEdge(4)");
        Test.end();
    }
}

