/*
 * Decompiled with CFR 0.152.
 */
package jdd.util;

public class RingQueue {
    private int size;
    private int read;
    private int write;
    private Object[] data;

    public RingQueue(int n) {
        this.size = ++n;
        this.data = new Object[n];
        this.reset();
    }

    public void reset() {
        this.write = 0;
        this.read = 0;
    }

    public boolean empty() {
        return this.read == this.write;
    }

    public void enqueue(Object object) {
        this.data[this.write] = object;
        this.write = (this.write + 1) % this.size;
    }

    public Object dequeue() {
        if (this.empty()) {
            return null;
        }
        Object object = this.data[this.read];
        this.read = (this.read + 1) % this.size;
        return object;
    }
}

