/*
 * Decompiled with CFR 0.152.
 */
package jdd.sat.dpll;

import java.io.IOException;
import jdd.sat.Clause;
import jdd.sat.DimacsReader;
import jdd.sat.Lit;
import jdd.sat.Var;
import jdd.sat.dpll.DPLLSolver;

public class DPLLSolver_MOMS
extends DPLLSolver {
    private static final long[] MOMS_k1 = new long[]{0L, 125L, 125L, 25L, 5L, 1L};
    private static final long MOMS_k2 = 1024L;

    public DPLLSolver_MOMS(long l) {
        super(l);
    }

    public DPLLSolver_MOMS() {
    }

    private long MOMS_getWeight(Clause clause) {
        int n = clause.top;
        if (n < MOMS_k1.length) {
            return MOMS_k1[n];
        }
        return MOMS_k1[MOMS_k1.length - 1];
    }

    private long MOMS_getWeight(Var var) {
        int n = var.index;
        int[] nArray = this.occurs[var.index];
        int n2 = nArray.length;
        long l = 0L;
        long l2 = 0L;
        for (int i = 0; i < n2; ++i) {
            Clause clause = this.org[nArray[i]];
            if (this.isRemoved(clause)) continue;
            for (int j = 0; j < clause.top; ++j) {
                Lit lit = clause.lits[j];
                if (n != lit.index) continue;
                long l3 = this.MOMS_getWeight(clause);
                if (lit.neg) {
                    l += l3;
                    continue;
                }
                l2 += l3;
            }
        }
        return l * l2 * 1024L + l2 + l;
    }

    @Override
    protected Var varToBranch() {
        long l = 0L;
        Var[] varArray = this.cnf.vars;
        int n = 0;
        for (int i = 0; i < this.var_top; ++i) {
            int n2 = this.var_stack[i];
            long l2 = this.MOMS_getWeight(varArray[n2]);
            if (l2 > l) {
                l2 = l;
            }
            if (l2 != l) continue;
            this.choice_stack2[n++] = n2;
        }
        Var var = varArray[this.choice_stack2[(int)(Math.random() * (double)n)]];
        return var;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.err.println("Need DIMACS file as argument");
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    System.out.print("Solving " + stringArray[i] + "\t\t");
                    DimacsReader dimacsReader = new DimacsReader(stringArray[i], true);
                    DPLLSolver_MOMS dPLLSolver_MOMS = new DPLLSolver_MOMS();
                    dPLLSolver_MOMS.setFormula(dimacsReader.getFormula());
                    dimacsReader = null;
                    int[] nArray = dPLLSolver_MOMS.solve();
                    dPLLSolver_MOMS.cleanup();
                    continue;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }
}

