/*
 * Decompiled with CFR 0.152.
 */
package jdd.graph;

import java.util.Enumeration;
import jdd.graph.AttributeExplorer;
import jdd.graph.Edge;
import jdd.graph.Graph;
import jdd.graph.Node;
import jdd.util.Test;

public class DepthFirstSearch {
    private static int dfs_time;

    public static void DFS(Graph graph) {
        AttributeExplorer.setAllNodesExtra1(graph, 0);
        dfs_time = 0;
        Enumeration enumeration = graph.getNodes().elements();
        while (enumeration.hasMoreElements()) {
            Node node = (Node)enumeration.nextElement();
            if (node.extra1 != 0) continue;
            DepthFirstSearch.DFS_visit_internal(node);
        }
    }

    private static void DFS_visit_internal(Node node) {
        node.extra3 = ++dfs_time;
        node.extra1 = 1;
        Edge edge = node.firstOut;
        while (edge != null) {
            Node node2 = edge.n2;
            if (node2.extra1 == 0) {
                DepthFirstSearch.DFS_visit_internal(node2);
            }
            edge = edge.next;
        }
        node.extra1 = 2;
        node.extra4 = ++dfs_time;
    }

    public static void DFS_label_simple(Graph graph, Node node) {
        AttributeExplorer.setAllNodesExtra1(graph, -1);
        DepthFirstSearch.DFS_label_internal(graph, node, 0, graph.isDirected());
    }

    public static void DFS_label_complete(Graph graph, Node node) {
        boolean bl = graph.isDirected();
        AttributeExplorer.setAllNodesExtra1(graph, -1);
        int n = DepthFirstSearch.DFS_label_internal(graph, node, 0, bl);
        Enumeration enumeration = graph.getNodes().elements();
        while (enumeration.hasMoreElements()) {
            Node node2 = (Node)enumeration.nextElement();
            if (node2.extra1 >= 0) continue;
            n = DepthFirstSearch.DFS_label_internal(graph, node2, n, bl);
        }
    }

    private static int DFS_label_internal(Graph graph, Node node, int n, boolean bl) {
        Node[] nodeArray = new Node[graph.numOfNodes()];
        int n2 = 0;
        nodeArray[n2++] = node;
        while (n2 > 0) {
            Node node2 = nodeArray[--n2];
            node2.extra1 = n++;
            Edge edge = node2.firstOut;
            while (edge != null) {
                if (edge.n2.extra1 == -1) {
                    edge.n2.extra1 = -2;
                    nodeArray[n2++] = edge.n2;
                }
                edge = edge.next;
            }
            if (bl) continue;
            edge = node2.firstIn;
            while (edge != null) {
                if (edge.n1.extra1 == -1) {
                    edge.n1.extra1 = -2;
                    nodeArray[n2++] = edge.n1;
                }
                edge = edge.prev;
            }
        }
        return n;
    }

    public static void internal_test() {
        Test.start("DepthFirstSearch");
        Graph graph = new Graph(true);
        Node node = graph.addNode();
        Node node2 = graph.addNode();
        Node node3 = graph.addNode();
        Node node4 = graph.addNode();
        Node node5 = graph.addNode();
        Node node6 = graph.addNode();
        graph.addEdge(node, node2);
        graph.addEdge(node2, node3);
        graph.addEdge(node2, node4);
        for (int i = 0; i < 2; ++i) {
            if (i == 0) {
                DepthFirstSearch.DFS_label_simple(graph, node);
            } else {
                DepthFirstSearch.DFS_label_complete(graph, node);
            }
            Test.checkEquality(node.extra1, 0, "node 1");
            Test.checkEquality(node2.extra1, 1, "node 2");
            Test.checkGreaterThan(node3.extra1, node2.extra1, "node 3");
            Test.checkGreaterThan(node4.extra1, node2.extra1, "node 4");
            Test.checkInequality(node3.extra1, node4.extra1, "parallel nodes have not same label");
            if (i == 0) {
                Test.checkEquality(node5.extra1, -1, "unreachable node should not be labelled (1)");
                Test.checkEquality(node6.extra1, -1, "unreachable node should not be labelled (2)");
                continue;
            }
            int n = Math.max(node3.extra1, node4.extra1);
            Test.checkGreaterThan(node5.extra1, n, "unreachable node should be labelled (1)");
            Test.checkGreaterThan(node6.extra1, n, "unreachable node should be labelled (2)");
            Test.checkInequality(node5.extra1, node6.extra1, "unreachable nodes have not same label");
        }
        Test.end();
    }
}

