/*
 * Decompiled with CFR 0.152.
 */
package jdd.graph;

import java.util.Enumeration;
import java.util.TreeSet;
import jdd.graph.AttributeExplorer;
import jdd.graph.Edge;
import jdd.graph.Factory;
import jdd.graph.Graph;
import jdd.graph.GraphIO;
import jdd.graph.Node;
import jdd.graph.NodeExtra1Comparator;
import jdd.util.Test;

public class ApproximationAlgorithms {
    public static void approx_vertex_cover_ED(Graph graph) {
        AttributeExplorer.changeAllNodesFlag(graph, 0, 2);
        AttributeExplorer.setAllEdgesExtra1(graph, 1);
        Enumeration enumeration = graph.getEdges().elements();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            if (edge.extra1 != 1) continue;
            ApproximationAlgorithms.vc_add_node(edge.n1);
            ApproximationAlgorithms.vc_add_node(edge.n2);
        }
    }

    private static int vc_add_node(Node node) {
        int n = 0;
        if ((node.flags & 2) == 0) {
            node.flags |= 2;
            Edge edge = node.firstOut;
            while (edge != null) {
                if (edge.extra1 != 0) {
                    ++n;
                    edge.extra1 = 0;
                }
                edge = edge.next;
            }
            edge = node.firstIn;
            while (edge != null) {
                if (edge.extra1 != 0) {
                    ++n;
                    edge.extra1 = 0;
                }
                edge = edge.prev;
            }
        }
        return n;
    }

    public static void approx_vertex_cover_MDG(Graph graph) {
        Node node;
        AttributeExplorer.changeAllNodesFlag(graph, 0, 2);
        TreeSet<Node> treeSet = new TreeSet<Node>(NodeExtra1Comparator.nodeExtra1Comparator);
        Enumeration enumeration = graph.getNodes().elements();
        while (enumeration.hasMoreElements()) {
            node = (Node)enumeration.nextElement();
            node.flags &= 0xFFFFFFFD;
            node.extra1 = node.getDegree();
            treeSet.add(node);
        }
        AttributeExplorer.setAllEdgesExtra1(graph, 1);
        for (int i = graph.numOfEdges(); i > 0 && !treeSet.isEmpty(); i -= ApproximationAlgorithms.vc_add_node(node)) {
            node = (Node)treeSet.first();
            treeSet.remove(node);
        }
    }

    private static void test_is_vertex_cover(Graph graph) {
        Enumeration enumeration = graph.getEdges().elements();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            Test.check((edge.n1.flags & 2) != 0 || (edge.n2.flags & 2) != 0, "Edge " + edge.getLabel() + " covered");
        }
    }

    public static void internal_test() {
        Test.start("ApproximationAlgorithms");
        Graph graph = GraphIO.loadEdgeList("data/p1025.pcg");
        ApproximationAlgorithms.approx_vertex_cover_ED(graph);
        ApproximationAlgorithms.test_is_vertex_cover(graph);
        ApproximationAlgorithms.approx_vertex_cover_MDG(graph);
        ApproximationAlgorithms.test_is_vertex_cover(graph);
        graph = Factory.complete(5);
        ApproximationAlgorithms.approx_vertex_cover_ED(graph);
        ApproximationAlgorithms.test_is_vertex_cover(graph);
        ApproximationAlgorithms.approx_vertex_cover_MDG(graph);
        ApproximationAlgorithms.test_is_vertex_cover(graph);
        Test.end();
    }
}

