/*
 * Decompiled with CFR 0.152.
 */
package jdd.examples;

import jdd.examples.Queens;
import jdd.util.Array;
import jdd.util.JDDConsole;
import jdd.util.Options;
import jdd.util.Test;
import jdd.zdd.ZDD2;

public class ZDDQueens
extends ZDD2
implements Queens {
    private int n;
    private int sols;
    private int[] pos_x;
    private int[] pos_xv;
    private boolean[] solvec;
    private long time = System.currentTimeMillis();
    private long memory;

    private int get(int n, int n2) {
        return this.pos_x[n + n2 * this.n];
    }

    private int getVar(int n, int n2) {
        return this.pos_xv[n + n2 * this.n];
    }

    public ZDDQueens(int n) {
        super(1 + Math.max(1000, (int)Math.pow(3.5, n - 6) * 1000), 10000);
        int n2;
        int n3;
        this.n = n;
        this.pos_x = new int[n * n];
        this.pos_xv = new int[n * n];
        boolean[] blArray = new boolean[n * n];
        for (n3 = 0; n3 < n * n; ++n3) {
            this.pos_xv[n3] = this.createVar();
            this.pos_x[n3] = this.ref(this.change(1, this.pos_xv[n3]));
        }
        n3 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            n3 = this.unionWith(n3, this.get(0, n2));
        }
        n2 = n3;
        for (int i = 1; i < n; ++i) {
            int n4 = 0;
            for (int j = 0; j < n; ++j) {
                int n5 = this.build(i, j, n2, blArray);
                n4 = this.unionWith(n4, n5);
                this.deref(n5);
            }
            this.deref(n2);
            n2 = n4;
        }
        this.solvec = this.satOne(n2, null);
        this.sols = this.count(n2);
        this.deref(n2);
        this.time = System.currentTimeMillis() - this.time;
        if (Options.verbose) {
            this.showStats();
        }
        this.memory = this.getMemoryUsage();
        this.cleanup();
    }

    @Override
    public int getN() {
        return this.n;
    }

    @Override
    public double numberOfSolutions() {
        return this.sols;
    }

    @Override
    public long getTime() {
        return this.time;
    }

    public long getMemory() {
        return this.memory;
    }

    @Override
    public boolean[] getOneSolution() {
        return this.solvec;
    }

    private boolean valid(int n, int n2) {
        return n >= 0 && n < this.n && n2 >= 0 && n2 < this.n;
    }

    private int build(int n, int n2, int n3, boolean[] blArray) {
        int n4;
        int n5;
        int n6;
        this.ref(n3);
        Array.set(blArray, false);
        for (n6 = 0; n6 < n; ++n6) {
            blArray[n6 + this.n * n2] = true;
        }
        for (n6 = 1; n6 <= n; ++n6) {
            n5 = n - n6;
            n4 = n2 - n6;
            if (this.valid(n5, n4)) {
                blArray[n5 + this.n * n4] = true;
            }
            if (!this.valid(n5, n4 = n2 + n6)) continue;
            blArray[n5 + this.n * n4] = true;
        }
        for (n6 = 0; n6 < this.n * this.n; ++n6) {
            if (!blArray[n6]) continue;
            n4 = n6 / this.n;
            n5 = n6 % this.n;
            n3 = this.offsetWith(n3, this.getVar(n5, n4));
        }
        n6 = this.ref(this.mul(n3, this.get(n, n2)));
        this.deref(n3);
        return n6;
    }

    private int unionWith(int n, int n2) {
        int n3 = this.ref(this.union(n, n2));
        this.deref(n);
        return n3;
    }

    private int offsetWith(int n, int n2) {
        int n3 = this.ref(this.subset0(n, n2));
        this.deref(n);
        return n3;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 1) {
            ZDDQueens zDDQueens = new ZDDQueens(Integer.parseInt(stringArray[0]));
            JDDConsole.out.println("There are " + zDDQueens.numberOfSolutions() + " solutions (time: " + zDDQueens.getTime() + ")");
            return;
        }
    }

    public static void internal_test() {
        Test.start("ZDDQueens");
        int[] nArray = new int[]{1, 0, 0, 2, 10, 4, 40, 92, 352, 724, 2680};
        for (int i = 0; i < nArray.length; ++i) {
            ZDDQueens zDDQueens = new ZDDQueens(i + 1);
            Test.check(zDDQueens.numberOfSolutions() == (double)nArray[i], "correct solutions for " + (i + 1) + " queens");
        }
        Test.end();
        ZDDQueens zDDQueens = new ZDDQueens(6);
    }
}

