/*
 * Decompiled with CFR 0.152.
 */
package jdd.des.automata.bdd;

import jdd.bdd.Permutation;
import jdd.des.automata.Automata;
import jdd.des.automata.AutomataIO;
import jdd.des.automata.bdd.BDDAutomata;
import jdd.des.automata.bdd.BDDAutomataHelper;
import jdd.des.automata.bdd.DisjunctivePartitions;
import jdd.des.automata.bdd.SymbolicAutomataSearch;
import jdd.util.Options;

public class DisjunctiveSearch
implements SymbolicAutomataSearch {
    private DisjunctivePartitions dp;
    private BDDAutomata manager;

    public DisjunctiveSearch(DisjunctivePartitions disjunctivePartitions) {
        this.dp = disjunctivePartitions;
        this.manager = disjunctivePartitions.getBDDAutomata();
    }

    @Override
    public void cleanup() {
    }

    @Override
    public int forward(int n) {
        int n2;
        int n3 = this.manager.ref(n);
        do {
            n2 = n3;
            int n4 = this.image(n3);
            n3 = this.manager.orTo(n3, n4);
            this.manager.deref(n4);
        } while (n2 != n3);
        return n3;
    }

    public int image(int n) {
        int n2;
        int n3 = this.manager.getBDDCubeS();
        Permutation permutation = this.manager.getPermSp2S();
        int n4 = 0;
        for (n2 = 0; n2 < this.dp.getSize(); ++n2) {
            int n5 = this.manager.ref(this.manager.relProd(n, this.dp.getBDDTWave(n2), n3));
            n4 = this.manager.orTo(n4, n5);
            this.manager.deref(n5);
        }
        n2 = this.manager.ref(this.manager.replace(n4, permutation));
        this.manager.deref(n4);
        return n2;
    }

    public static void main(String[] stringArray) {
        try {
            Options.verbose = true;
            for (int i = 0; i < stringArray.length; ++i) {
                Automata automata = AutomataIO.loadXML(stringArray[i]);
                long l = System.currentTimeMillis();
                BDDAutomata bDDAutomata = new BDDAutomata(automata);
                DisjunctivePartitions disjunctivePartitions = new DisjunctivePartitions(bDDAutomata);
                DisjunctiveSearch disjunctiveSearch = new DisjunctiveSearch(disjunctivePartitions);
                int n = BDDAutomataHelper.getI(bDDAutomata);
                int n2 = disjunctiveSearch.forward(n);
                double d = BDDAutomataHelper.countStates(bDDAutomata, n2);
                disjunctivePartitions.cleanup();
                disjunctiveSearch.cleanup();
                bDDAutomata.cleanup();
                l = System.currentTimeMillis() - l;
                System.out.println("Found " + d + " states in " + stringArray[i] + " in " + l + "ms.");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

