/*
 * Decompiled with CFR 0.152.
 */
package jdd.des.automata.bdd;

import java.util.HashMap;
import jdd.bdd.BDDUtil;
import jdd.bdd.Permutation;
import jdd.bdd.debug.ProfiledBDD2;
import jdd.des.automata.Alphabet;
import jdd.des.automata.Automata;
import jdd.des.automata.AutomataIO;
import jdd.des.automata.Automaton;
import jdd.des.automata.Event;
import jdd.des.automata.analysis.AutomataAnalyzer;
import jdd.des.automata.bdd.AutomataOrder;
import jdd.des.automata.bdd.BDDAutomataHelper;
import jdd.des.automata.bdd.BDDAutomaton;
import jdd.graph.Graph;
import jdd.graph.Node;
import jdd.util.Test;
import jdd.util.math.Digits;

public class BDDAutomata
extends ProfiledBDD2 {
    Automata original;
    BDDAutomaton[] automata;
    private HashMap automaton2bddautomaton;
    private Graph pcg;
    private HashMap node_to_automaton_map;
    private HashMap automaton_to_node_map;
    private int event_bits;
    private int state_bits;
    private int[] bdd_var_events;
    private int bdd_care_events;
    private int bdd_cube_events;
    private int bdd_cube_s;
    private int bdd_cube_sp;
    private int bdd_keep_states;
    private Permutation perm_s2sp;
    private Permutation perm_sp2s;

    public BDDAutomata(Automata automata) {
        super(BDDAutomataHelper.suggestInitialNodes(automata), BDDAutomataHelper.suggestInitialNodes(automata) / 10);
        Object object;
        Object object2;
        Object object3;
        int n;
        this.original = automata;
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        this.pcg = AutomataAnalyzer.getPCG(this.original, hashMap, hashMap2);
        AutomataOrder automataOrder = new AutomataOrder(this.pcg, hashMap);
        Automaton[] automatonArray = automataOrder.getBestOrder();
        try {
            this.bdd_keep_states = 1;
            this.state_bits = 0;
            this.bdd_cube_sp = 1;
            this.bdd_cube_s = 1;
            this.automaton2bddautomaton = new HashMap();
            this.automata = new BDDAutomaton[this.original.size()];
            for (n = 0; n < this.automata.length; ++n) {
                this.automata[n] = null;
            }
            for (n = 0; n < automatonArray.length; ++n) {
                object3 = automatonArray[n];
                this.automata[n] = new BDDAutomaton((Automaton)object3, this);
                this.automaton2bddautomaton.put(object3, this.automata[n]);
                this.bdd_keep_states = this.andTo(this.bdd_keep_states, this.automata[n].getBDDKeep());
                this.bdd_cube_s = this.andTo(this.bdd_cube_s, this.automata[n].getBDDCubeS());
                this.bdd_cube_sp = this.andTo(this.bdd_cube_sp, this.automata[n].getBDDCubeSp());
                this.state_bits += this.automata[n].getNumBits();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.cleanup();
            throw illegalArgumentException;
        }
        this.node_to_automaton_map = new HashMap();
        this.automaton_to_node_map = new HashMap();
        object3 = this.pcg.getNodes().elements();
        while (object3.hasMoreElements()) {
            object2 = (Node)object3.nextElement();
            object = (Automaton)hashMap.get(object2);
            BDDAutomaton bDDAutomaton = this.getBDDAutomaton((Automaton)object);
            this.node_to_automaton_map.put(object2, bDDAutomaton);
            this.automaton_to_node_map.put(bDDAutomaton, object2);
        }
        object3 = this.original.getEventManager();
        this.event_bits = Digits.log2_ceil(((Alphabet)object3).getSize());
        this.bdd_var_events = new int[this.event_bits];
        this.bdd_care_events = 0;
        this.bdd_cube_events = 1;
        for (n = 0; n < this.event_bits; ++n) {
            this.bdd_var_events[n] = this.createVar();
            this.bdd_care_events = this.orTo(this.bdd_care_events, this.bdd_var_events[n]);
            this.bdd_cube_events = this.andTo(this.bdd_cube_events, this.bdd_var_events[n]);
        }
        n = 0;
        object2 = ((Alphabet)object3).head();
        while (object2 != null) {
            ((Event)object2).setBDD(BDDUtil.numberToBDD(this, this.bdd_var_events, n));
            object2 = ((Event)object2).next;
            ++n;
        }
        object2 = new int[this.state_bits];
        object = new int[this.state_bits];
        int n2 = 0;
        for (n = 0; n < this.automata.length; ++n) {
            int n3 = this.automata[n].getNumBits();
            int[] nArray = this.automata[n].bdd_var_s;
            int[] nArray2 = this.automata[n].bdd_var_sp;
            for (int i = 0; i < n3; ++i) {
                object2[n2] = nArray[i];
                object[n2] = nArray2[i];
                ++n2;
            }
        }
        this.perm_s2sp = this.createPermutation((int[])object2, (int[])object);
        this.perm_sp2s = this.createPermutation((int[])object, (int[])object2);
        for (n = 0; n < this.automata.length; ++n) {
            this.automata[n].buildRelations(this);
        }
    }

    @Override
    public void cleanup() {
        for (int i = 0; i < this.automata.length; ++i) {
            if (this.automata[i] == null) continue;
            this.automata[i].cleanup();
        }
        super.cleanup();
    }

    public BDDAutomaton getBDDAutomaton(Automaton automaton) {
        return (BDDAutomaton)this.automaton2bddautomaton.get(automaton);
    }

    public Graph getPCG() {
        return this.pcg;
    }

    public BDDAutomaton getBDDAutomaton(Node node) {
        return (BDDAutomaton)this.node_to_automaton_map.get(node);
    }

    public Node getPCGNode(BDDAutomaton bDDAutomaton) {
        return (Node)this.automaton_to_node_map.get(bDDAutomaton);
    }

    public int getSize() {
        return this.automata.length;
    }

    public int getBDDCubeEvents() {
        return this.bdd_cube_events;
    }

    public int getBDDCubeS() {
        return this.bdd_cube_s;
    }

    public int getBDDCubeSp() {
        return this.bdd_cube_sp;
    }

    public int getBDDKeep() {
        return this.bdd_keep_states;
    }

    public Permutation getPermS2Sp() {
        return this.perm_s2sp;
    }

    public Permutation getPermSp2S() {
        return this.perm_sp2s;
    }

    public int getSVectorLength() {
        return this.state_bits;
    }

    public int getEVectorLength() {
        return this.event_bits;
    }

    public static void internal_test() {
        Test.start("BDDAutomata");
        Automata automata = AutomataIO.loadXML("data/phil.xml");
        BDDAutomata bDDAutomata = new BDDAutomata(automata);
        Test.check(bDDAutomata.getBDDCubeS() != bDDAutomata.getZero() && bDDAutomata.getBDDCubeS() != bDDAutomata.getOne(), "cubeS ");
        Test.check(bDDAutomata.getBDDCubeSp() != bDDAutomata.getZero() && bDDAutomata.getBDDCubeSp() != bDDAutomata.getOne(), "cubeSp ");
        Test.check(bDDAutomata.getBDDCubeEvents() != bDDAutomata.getZero() && bDDAutomata.getBDDCubeEvents() != bDDAutomata.getOne(), "cubeEvent ");
        int n = bDDAutomata.ref(bDDAutomata.and(bDDAutomata.getBDDCubeS(), bDDAutomata.getBDDCubeSp()));
        int n2 = bDDAutomata.ref(bDDAutomata.and(n, bDDAutomata.getBDDCubeEvents()));
        Test.checkEquality(bDDAutomata.satCount(n2), 1.0, "correct allocation of cubes");
        bDDAutomata.deref(n);
        bDDAutomata.deref(n2);
        Test.checkEquality(bDDAutomata.replace(bDDAutomata.getBDDCubeS(), bDDAutomata.getPermS2Sp()), bDDAutomata.getBDDCubeSp(), "S2Sp");
        Test.checkEquality(bDDAutomata.replace(bDDAutomata.getBDDCubeSp(), bDDAutomata.getPermSp2S()), bDDAutomata.getBDDCubeS(), "Sp2S");
        Test.checkEquality(bDDAutomata.replace(bDDAutomata.getBDDCubeEvents(), bDDAutomata.getPermSp2S()), bDDAutomata.getBDDCubeEvents(), "permutationsnot affecting events (1)");
        Test.checkEquality(bDDAutomata.replace(bDDAutomata.getBDDCubeEvents(), bDDAutomata.getPermS2Sp()), bDDAutomata.getBDDCubeEvents(), "permutationsnot affecting events (2)");
        bDDAutomata.cleanup();
        Test.end();
    }
}

