/*
 * Decompiled with CFR 0.152.
 */
package jdd.bdd;

import jdd.bdd.NodeTable;
import jdd.util.Allocator;
import jdd.util.Array;
import jdd.util.JDDConsole;
import jdd.util.Test;
import jdd.util.math.HashFunctions;

public class Permutation {
    private static int id_c = 0;
    int last;
    int first;
    int id;
    int hash;
    int[] perm;
    int[] from;
    int[] to;
    Permutation next;

    Permutation(int[] nArray, int[] nArray2, NodeTable nodeTable) {
        int n;
        Test.check(nArray.length == nArray2.length, "Permutations vectors must have equal length");
        Test.check(nArray.length > 0, "non empty pemuration vectors");
        this.from = Array.clone(nArray);
        this.to = Array.clone(nArray2);
        int n2 = nArray.length;
        int[] nArray3 = new int[n2];
        int[] nArray4 = new int[n2];
        for (n = 0; n < n2; ++n) {
            nArray3[n] = nodeTable.getVar(nArray[n]);
            nArray4[n] = nodeTable.getVar(nArray2[n]);
        }
        this.first = this.last = nArray3[0];
        for (n = 1; n < n2; ++n) {
            if (this.last < nArray3[n]) {
                this.last = nArray3[n];
            }
            if (this.first <= nArray3[n]) continue;
            this.first = nArray3[n];
        }
        this.perm = Allocator.allocateIntArray(this.last + 1);
        for (n = 0; n < this.last; ++n) {
            this.perm[n] = n;
        }
        for (n = 0; n < n2; ++n) {
            this.perm[nArray3[n]] = nArray4[n];
        }
        this.next = null;
        this.hash = Permutation.computeHash(nArray, nArray2);
        this.id = id_c++;
    }

    public void show() {
        JDDConsole.out.println("-----------------------------");
        for (int i = this.first; i <= this.last; ++i) {
            JDDConsole.out.println(" " + i + " --> " + this.perm[i]);
        }
    }

    public long getMemoryUsage() {
        return this.perm.length * 4 + this.from.length * 4 + this.to.length * 4;
    }

    static int computeHash(int[] nArray, int[] nArray2) {
        int n = HashFunctions.hash_FNV(nArray, 0, nArray.length);
        int n2 = HashFunctions.hash_FNV(nArray2, 0, nArray2.length);
        return HashFunctions.hash_FNV(n, n2, 0);
    }

    static Permutation findPermutation(Permutation permutation, int[] nArray, int[] nArray2) {
        int n = Permutation.computeHash(nArray, nArray2);
        while (permutation != null) {
            if (permutation.equals(n, nArray, nArray2)) {
                return permutation;
            }
            permutation = permutation.next;
        }
        return null;
    }

    boolean equals(int n, int[] nArray, int[] nArray2) {
        if (n != this.hash) {
            return false;
        }
        if (nArray.length != this.from.length || nArray2.length != this.to.length) {
            return false;
        }
        if (!Array.equals(nArray, this.from, nArray.length)) {
            return false;
        }
        return Array.equals(nArray2, this.to, nArray2.length);
    }
}

