/*
 * Decompiled with CFR 0.152.
 */
package jdd.applet;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.StringBufferInputStream;
import jdd.bdd.debug.BDDTrace;
import jdd.util.JDDConsole;
import jdd.util.Options;
import jdd.util.TextAreaTarget;

public class TraceApplet
extends Applet
implements ActionListener {
    private TextArea msg;
    private TextArea code;
    private Button bRun;
    private Button bClear;
    private Checkbox cbVerbose;
    private Choice initialNodes;
    private String initial_text = "MODULE c17\nINPUT\n\t1gat,2gat,3gat,6gat,7gat;\nOUTPUT\n\t22gat,23gat;\nSTRUCTURE\n\t10gat = nand(1gat, 3gat);\n\t11gat = nand(3gat, 6gat);\n\t16gat = nand(2gat, 11gat);\n\t19gat = nand(11gat, 7gat);\n\t22gat = nand(10gat, 16gat);\n\t23gat = nand(16gat, 19gat);\n\tprint_bdd(23gat);\nENDMODULE\n";

    public TraceApplet() {
        Color color = new Color(224, 224, 224);
        this.setBackground(color);
        this.setLayout(new BorderLayout());
        Panel panel = new Panel(new FlowLayout(0));
        panel.setBackground(color);
        this.add((Component)panel, "North");
        this.bRun = new Button("Run");
        panel.add(this.bRun);
        this.bClear = new Button("Clear");
        panel.add(this.bClear);
        panel.add(new Label("  Initial node-base"));
        this.initialNodes = new Choice();
        panel.add(this.initialNodes);
        this.initialNodes.add("10");
        this.initialNodes.add("100");
        this.initialNodes.add("1000");
        this.initialNodes.add("10000");
        this.initialNodes.add("100000");
        this.initialNodes.select(3);
        this.cbVerbose = new Checkbox("verbose", false);
        panel.add(this.cbVerbose);
        this.code = new TextArea(25, 80);
        this.add((Component)this.code, "Center");
        this.msg = new TextArea(16, 80);
        this.add((Component)this.msg, "South");
        this.msg.setEditable(false);
        this.msg.setBackground(color);
        this.bRun.addActionListener(this);
        this.bClear.addActionListener(this);
        JDDConsole.out = new TextAreaTarget(this.msg);
        this.code.setFont(new Font("Monospaced", 0, 12));
        this.code.setBackground(Color.yellow);
        this.code.setForeground(Color.red);
        this.code.setText(this.initial_text);
        this.msg.setText("\n       This is C17, from Yirng-An Chen's ISCAS'85 traces.\n\n");
        this.msg.setFont(new Font(null, 0, 10));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.bRun) {
            this.doRun();
        } else if (object == this.bClear) {
            this.doClear();
        }
    }

    private void doClear() {
        this.msg.setText("");
    }

    private void doRun() {
        BDDTrace.verbose = Options.verbose = this.cbVerbose.getState();
        StringBufferInputStream stringBufferInputStream = new StringBufferInputStream(this.code.getText());
        int n = Integer.parseInt(this.initialNodes.getSelectedItem());
        try {
            BDDTrace bDDTrace = new BDDTrace("(memory)", stringBufferInputStream, n);
        }
        catch (IOException iOException) {
            JDDConsole.out.println("ERROR: " + iOException);
        }
    }
}

