/*
 *  The MIT License
 *
 *  Copyright 2014 Masahiko, SAWAI <masahiko.sawai@gmail.com>.
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a copy
 *  of this software and associated documentation files (the "Software"), to deal
 *  in the Software without restriction, including without limitation the rights
 *  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *  copies of the Software, and to permit persons to whom the Software is
 *  furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 *  THE SOFTWARE.
 */
package org.routine_work.simple_battery_logger.service;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import android.os.Environment;
import java.io.File;
import java.util.Date;
import org.routine_work.simple_battery_logger.BatteryConstants;
import org.routine_work.simple_battery_logger.util.CsvFilenameFilter;
import org.routine_work.simple_battery_logger.util.PreferenceUtils;
import org.routine_work.util.Log;

/**
 *
 * @author sawai
 */
public class AllCsvFileMediaScanService extends IntentService
{

	private static final String LOG_TAG = "simple-battery-logger";

	public AllCsvFileMediaScanService(String name)
	{
		super(name);
	}

	public AllCsvFileMediaScanService()
	{
		this("AllCsvFileMediaScanService");
	}

	@Override
	protected void onHandleIntent(Intent intent)
	{
		Log.i(LOG_TAG, "AllCsvFileMediaScanService : Start at " + new Date());

		Context context = this.getApplicationContext();
		if (PreferenceUtils.isCsvAutoExportEnabled(context) == false)
		{
			String csvExportDirectoryName = PreferenceUtils.getCsvExportDirectoryName(context);
			File externalStorageDirectory = Environment.getExternalStorageDirectory();
			File csvExportDirectory = new File(externalStorageDirectory, csvExportDirectoryName);
			if (csvExportDirectory.exists()
				&& csvExportDirectory.isDirectory()
				&& csvExportDirectory.canRead())
			{
				File[] csvFiles = csvExportDirectory.listFiles(new CsvFilenameFilter());
				if (csvFiles != null)
				{
					Log.d(LOG_TAG, "AllCsvFileMediaScanService : csvFiles.length => " + csvFiles.length);
					for (File csvFile : csvFiles)
					{
						String csvFilePath = csvFile.getAbsolutePath();
						Intent startCsvFileMediaScanService = new Intent(context, CsvFileMediaScanService.class);
						startCsvFileMediaScanService.putExtra(BatteryConstants.EXTRA_CSV_FILE_PATH, csvFilePath);
						context.startService(startCsvFileMediaScanService);
					}
				}
			}

			PreferenceUtils.putCsvMediaScanCompleted(context, true);
		}

		Log.i(LOG_TAG, "AllCsvFileMediaScanService : End at " + new Date());
	}
}
