package com.wiki.standalone.moxkiriya.parser.blockparser;


public interface WikiBlockParser {
	/** parse状態 */
	public enum Status {
		INIT,
		OPEN,
		NESTING,
		CLOSE
	};

	/**
	 * Block要素開始処理。
	 * @param buf　バッファ
	 * @return 処理後の文字列
	 */
	public String startElementProcess(String line, StringBuffer buf);

	/**
	 * WikiのSyntaxを解析し、HTML形式の文字列に変換する。
	 * @param line readerから読み込んだ最初の行
	 * @param buf バッファ
	 * @return 処理後の文字列
	 */
	public String parse(String line, StringBuffer buf) throws Exception;

	/**
	 * Block要素終了処理。
	 * @param buf
	 * @return 処理後の文字列
	 */
	public String endElementProcess(String line, StringBuffer buf);

	/**
	 * ネスト要素のcloseをヘルプする。
	 * 先祖の要素に<code>があった場合、ネスト要素を&lt;要素&gt;にするため。
	 * @param tagPart
	 * @return 処理したクローズタグ文字列
	 */
	public String daughterElementCloseHelper(String tagPart);

		/**
	 * 要素Block終了判定
	 * @return 終了判定結果
	 */
	public boolean isBlockEnd();

	/**
	 * 処理中の1行のうち処理した文字数を取得する。
	 * @return 処理した文字数
	 */
	public int getCount();
}
