package littlemaid.network;

import io.netty.buffer.ByteBuf;

import java.io.IOException;

import littlemaid.entity.EntityLittleMaid;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

/**
 * メイドさんの手持ちアイテムと装備品のみをパッケージしてクライアントのメイドさんへ同期する。
 * 見た目に関係するアイテムだけを送ることで、ご主人様以外のプレイヤーの負荷が減る…かも
 */
public class MessageSyncEquip implements IMessage {

	private int entityId;
	private ItemStack[] equipments = new ItemStack[5];

	public MessageSyncEquip() {}

	/**
	 * 指定されたメイドさんの装備品を同期するためのメッセージを作成する
	 * @param maid 装備同期対象のメイドさん
	 */
	public MessageSyncEquip(EntityLittleMaid maid) {
		// メイドさんのID
		this.entityId = maid.getEntityId();
		// 手持ちアイテムと装備品
		this.equipments[0] = maid.inventory.getStackInSlot(0);
		for (int i = 1; i <= 4; i++) {
			this.equipments[i] = maid.inventory.getStackInSlot(maid.inventory.getSizeInventory() - i);
		}
	}

	@Override
	public void fromBytes(ByteBuf buf) {
		PacketBuffer pbuf = new PacketBuffer(buf);
        try {
        	this.entityId = pbuf.readInt();
    		for (int i = 0; i <= 4; i++) {
    			this.equipments[i] = pbuf.readItemStackFromBuffer();
    		}
		}
		catch (IOException e) {
			e.printStackTrace();
		}
	}

	@Override
	public void toBytes(ByteBuf buf) {
		PacketBuffer pbuf = new PacketBuffer(buf);
		pbuf.writeInt(this.entityId);
		for (int i = 0; i <= 4; i++) {
			pbuf.writeItemStackToBuffer(this.equipments[i]);
		}
	}

	/**
	 * メイドさんのEntityIDを取得
	 */
	public int getMaidEntityID() {
		return this.entityId;
	}

	/**
	 * メイドさんの装備品を取得
	 */
	public ItemStack[] getEquipItems() {
		return this.equipments;
	}

}
