package littlemaid.entity.ai;

import littlemaid.entity.EntityLittleMaid;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;

public class EntityAIWait extends EntityAIBase {

	private EntityLittleMaid theEntity;
	/** If the EntityLittleMaid is waiting. */
	private boolean isWaiting;

	public EntityAIWait(EntityLittleMaid entityIn) {
		this.theEntity = entityIn;
		this.setMutexBits(5);
	}

	/**
	 * Returns whether the EntityAIBase should begin execution.
	 */
	@Override
	public boolean shouldExecute()
	{
		if (!this.theEntity.isContract())
		{
			return false;
		}
		else if (this.theEntity.isInWater())
		{
			return false;
		}
		else if (!this.theEntity.onGround)
		{
			return false;
		}
		else
		{
			EntityLivingBase entitylivingbase = this.theEntity.getOwnerEntity();
			return entitylivingbase == null ? true : (this.theEntity.getDistanceSqToEntity(entitylivingbase) < 144.0D && entitylivingbase.getAITarget() != null ? false : this.isWaiting);
		}
	}

	/**
	 * Execute a one shot task or start executing a continuous task
	 */
	public void startExecuting()
	{
		this.theEntity.getNavigator().clearPathEntity();
		this.theEntity.setWaiting(true);
	}

	/**
	 * Resets the task
	 */
	public void resetTask()
	{
		this.theEntity.setWaiting(false);
	}

	/**
	 * Sets the waiting flag.
	 */
	public void setWaiting(boolean waiting)
	{
		this.isWaiting = waiting;
	}
}
