package littlemaid.entity.ai;

import littlemaid.entity.EntityLittleMaid;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

/**
 * ケーキとお砂糖を持っているとおねだりするAI
 */
public class EntityAIBeg extends EntityAIBase {

    private EntityLittleMaid theMaid;
    private EntityPlayer thePlayer;
    private World worldObject;
    private float minPlayerDistance;
    private int waitCount;

	public EntityAIBeg(EntityLittleMaid maid, float minDist) {
        this.theMaid = maid;
        this.worldObject = maid.worldObj;
        this.minPlayerDistance = minDist;
        this.setMutexBits(2);
	}

	@Override
	public boolean shouldExecute() {
        this.thePlayer = this.worldObject.getClosestPlayerToEntity(this.theMaid, (double)this.minPlayerDistance);
        return this.thePlayer == null ? false : this.hasPlayerGotCakeInHand(this.thePlayer);
	}

    public boolean continueExecuting()
    {
        return !this.thePlayer.isEntityAlive() ? false : (this.theMaid.getDistanceSqToEntity(this.thePlayer) > (double)(this.minPlayerDistance * this.minPlayerDistance) ? false : this.waitCount > 0 && this.hasPlayerGotCakeInHand(this.thePlayer));
    }


    public void startExecuting()
    {
        this.theMaid.setBeg(true);
        this.waitCount = 40 + this.theMaid.getRNG().nextInt(40);
    }


    public void resetTask()
    {
        this.theMaid.setBeg(false);
        this.thePlayer = null;
    }


    public void updateTask()
    {
        this.theMaid.getLookHelper().setLookPosition(this.thePlayer.posX, this.thePlayer.posY + (double)this.thePlayer.getEyeHeight(), this.thePlayer.posZ, 10.0F, (float)this.theMaid.getVerticalFaceSpeed());
        --this.waitCount;
    }

	private boolean hasPlayerGotCakeInHand(EntityPlayer playerIn)
	{
        ItemStack itemstack = playerIn.inventory.getCurrentItem();
        return itemstack == null ? false : (!this.theMaid.isContract() && itemstack.getItem() == Items.cake ? true : itemstack.getItem() == Items.sugar);
	}

}
