package littlemaid.entity;

import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(Side.CLIENT)
public class ModelLittleMaid extends ModelBiped {

	public ModelRenderer skirt;
	public ModelRenderer landingSkirt;

	public ModelLittleMaid() {
		this(0.0F);
	}

	public ModelLittleMaid(float scaleFactor) {
		this(scaleFactor, 0.0F, 64, 32);
	}

	public ModelLittleMaid(float scaleFactor, float yOffset, int textureWidth, int textureHeight) {
		// スーパークラスのコンストラクタで追加された使われないモデルを一旦削除
		this.boxList.clear();

		// ModelRenderer(Model, textureX, textureY)
		this.bipedHead = new ModelRenderer(this, 0, 0);
		this.bipedHead.setTextureOffset(0, 0).addBox(-4F, -8F, -4F, 8, 8, 8, scaleFactor); // Head
		this.bipedHead.setTextureOffset(24, 0).addBox(-4F, 0F, 1F, 8, 4, 3, scaleFactor); // Heir
		this.bipedHead.setTextureOffset(24, 18).addBox(-5F, -7F, 0.2F, 1, 3, 3, scaleFactor); // ChignonR
		this.bipedHead.setTextureOffset(24, 18).addBox(4F, -7F, 0.2F, 1, 3, 3, scaleFactor); // ChignonL
		this.bipedHead.setTextureOffset(52, 10).addBox(-2F, -7.2F, 4F, 4, 4, 2, scaleFactor); // ChignonB
		this.bipedHead.setTextureOffset(46, 20).addBox(-1.5F, -6.8F, 4F, 3, 9, 3, scaleFactor); // Tail
		this.bipedHead.setTextureOffset(58, 21).addBox(-5.5F, -6.8F, 0.9F, 1, 8, 2, scaleFactor); // SideTailR
		this.bipedHead.mirror = true;
		this.bipedHead.setTextureOffset(58, 21).addBox(4.5F, -6.8F, 0.9F, 1, 8, 2, scaleFactor); // SideTailL
		this.bipedHead.setRotationPoint(0F, 0F, 0F);

		this.bipedHeadwear = new ModelRenderer(this, 0, 0);
		this.bipedHeadwear.isHidden = true;

		this.bipedBody = new ModelRenderer(this, 32, 8);
		this.bipedBody.addBox(-3F, 0F, -2F, 6, 7, 4, scaleFactor);
		this.bipedBody.setRotationPoint(0F, 0F, 0F);

		this.bipedRightArm = new ModelRenderer(this, 48, 0);
		this.bipedRightArm.addBox(-2.0F, -1F, -1F, 2, 8, 2, scaleFactor);
		this.bipedRightArm.setRotationPoint(-2.5F, 1.5F, 0F);

		this.bipedLeftArm = new ModelRenderer(this, 56, 0);
		this.bipedLeftArm.mirror = true;
		this.bipedLeftArm.addBox(0.0F, -1F, -1F, 2, 8, 2, scaleFactor);
		this.bipedLeftArm.setRotationPoint(2.5F, 1.5F, 0F);

		this.bipedRightLeg = new ModelRenderer(this, 32, 19);
		this.bipedRightLeg.addBox(-2F, 0F, -2F, 3, 9, 4, scaleFactor);
		this.bipedRightLeg.setRotationPoint(-1.0F, 7.0F, 0F);

		this.bipedLeftLeg = new ModelRenderer(this, 32, 19);
		this.bipedLeftLeg.mirror = true;
		this.bipedLeftLeg.addBox(-1F, 0F, -2F, 3, 9, 4, scaleFactor);
		this.bipedLeftLeg.setRotationPoint(1.0F, 7.0F, 0F);

		this.skirt = new ModelRenderer(this, 0, 16);
		this.skirt.addBox(-4F, 0F, -4F, 8, 8, 8, scaleFactor);
		this.skirt.setRotationPoint(0F, 5.0F, 0F);

		this.landingSkirt = new ModelRenderer(this, 0, 16);
		this.landingSkirt.addBox(-4F, 0F, -4F, 8, 8, 8, scaleFactor + 0.6F);
		this.landingSkirt.setRotationPoint(0F, 5.0F, 0F);
		this.landingSkirt.isHidden = true;

	}

	/**
	 * distance   移動距離。増えるのみ
	 * intensity  動くと増え、止まると減る。ただし0～1の範囲で緩やかに増減する
	 * livingTime 生きている時間
	 */
	@Override
	public void render(Entity entity, float distance, float intensity, float livingTime, float headRotateYaw, float headRotatePitch, float scale) {

		GlStateManager.pushMatrix();

		// 下に8ドット分ずらす
		GlStateManager.translate(0.0F, 8.0F * scale, 0.0F);

		super.render(entity, distance, intensity, livingTime, headRotateYaw, headRotatePitch, scale);
		this.skirt.render(scale);
		this.landingSkirt.render(scale);

		GlStateManager.popMatrix();
	}

	/**
	 * 描画前に各パーツの位置決めを行う
	 */
	@Override
	public void setRotationAngles(float distance, float intensity, float livingTime, float headRotateYaw, float headRotatePitch, float scale, Entity entity) {

		EntityLittleMaid theMaid = (EntityLittleMaid) entity;

		// 継承元にはアイテムを持っていないものとして設定してもらう
		int heldItemWork = this.heldItemRight;
		this.heldItemRight = 0;
		super.setRotationAngles(distance, intensity, livingTime, headRotateYaw, headRotatePitch, scale, entity);
		this.heldItemRight = heldItemWork;

		// 基本姿勢
		this.bipedRightArm.rotateAngleX = MathHelper.cos(distance * 0.8F + (float) Math.PI) * intensity;
		this.bipedLeftArm.rotateAngleX = MathHelper.cos(distance * 0.8F) * intensity;
		this.bipedRightLeg.rotateAngleX = MathHelper.cos(distance * 0.8F) * intensity * 0.6F;
		this.bipedLeftLeg.rotateAngleX = MathHelper.cos(distance * 0.8F + (float) Math.PI) * intensity * 0.6F;

		this.bipedRightArm.rotationPointX = -2.5F;
		this.bipedLeftArm.rotationPointX = 2.5F;
		this.bipedRightLeg.rotationPointY = 7.0F;
		this.bipedLeftLeg.rotationPointY = 7.0F;
		this.bipedRightArm.rotateAngleZ += (float) Math.PI / 10.0F;
		this.bipedLeftArm.rotateAngleZ -= (float) Math.PI / 10.0F;

		// アイテム保持時の腕角度
		switch (this.heldItemRight)
		{
		case 0:
		case 2:
		default:
			break;
		case 1:
			this.bipedRightArm.rotateAngleX = this.bipedRightArm.rotateAngleX * 0.3F - ((float) Math.PI / 18.0F) * (float) this.heldItemRight;
			break;
		case 3:
			this.bipedRightArm.rotateAngleX = this.bipedRightArm.rotateAngleX * 0.3F - ((float) Math.PI / 18.0F) * (float) this.heldItemRight;
			this.bipedRightArm.rotateAngleY = 0.2F;
		}

		// swingProgress

		// 待機時の腕角度
		if (theMaid.isWaiting())
		{
			this.bipedRightArm.rotateAngleX = -(float) Math.PI / 3.3F; // 前へ出す角度
			this.bipedRightArm.rotateAngleY = -((float) Math.PI / 4.5F); // 内側に寄せる角度
			this.bipedLeftArm.rotateAngleX = -(float) Math.PI / 3.3F;
			this.bipedLeftArm.rotateAngleY = ((float) Math.PI / 4.5F);
		}

		// 落下時のスカート表示
		this.landingSkirt.isHidden = !theMaid.isLanding();
		this.skirt.isHidden = theMaid.isLanding();

	}

	/**
	 * ちょっとしたアニメーションを入れるときに使う
	 */
	@Override
	public void setLivingAnimations(EntityLivingBase entity, float distance, float intensity, float partialTicks) {

		EntityLittleMaid theMaid = (EntityLittleMaid) entity;

		this.bipedHead.rotateAngleZ = theMaid.getInterestedAngle(partialTicks);
	}

	@Override
	public void postRenderArm(float p_178718_1_) {
		super.postRenderArm(p_178718_1_);
	}

	@Override
	public void setInvisible(boolean invisible) {
		super.setInvisible(invisible);
		this.skirt.showModel = invisible;
		this.landingSkirt.showModel = invisible;
	}

}
