package littlemaid;

import littlemaid.entity.EntityLittleMaid;
import littlemaid.gui.GuiHandlerLittleMaid;
import littlemaid.network.MessagePlaySound;
import littlemaid.network.MessagePlaySoundHandler;
import littlemaid.network.MessageRequestEquip;
import littlemaid.network.MessageRequestEquipHandler;
import littlemaid.network.MessageSyncEquip;
import littlemaid.network.MessageSyncEquipHandler;
import net.minecraft.entity.EntityList;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatBasic;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.Mod.EventHandler;
import net.minecraftforge.fml.common.Mod.Instance;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;

import org.apache.logging.log4j.Logger;

@Mod(modid = LittleMaidCore.MODID,
	name = LittleMaidCore.MODID,
	version = LittleMaidCore.VERSION)
public class LittleMaidCore {

	public static final String MODID = "LittleMaid";
	public static final String VERSION = "for academic";

	private static Logger logger;

	@Instance(MODID)
	public static LittleMaidCore instance;

	@SidedProxy(clientSide = "littlemaid.ProxyClient", serverSide = "littlemaid.ProxyCommon")
	public static ProxyCommon proxy;

    //このMOD用のSimpleNetworkWrapperを生成。チャンネルの文字列は固有であれば何でも良い。MODIDの利用を推奨。
    //チャンネル名は20文字以内の文字数制限があるので注意。
    public static final SimpleNetworkWrapper MESSAGE = NetworkRegistry.INSTANCE.newSimpleChannel(MODID);

	// 実績ページ名
	//public static final String ACHIEVEMENT_PAGE_NAME = "LittleMaid";

	// 統計
    /** 雇用回数 */
    public static StatBase employmentNumber = (new StatBasic(LittleMaidCore.MODID + ".achievement.employmentNumber", new ChatComponentTranslation(LittleMaidCore.MODID + ".achievement.employmentNumber", new Object[0]))).initIndependentStat().registerStat();
    /** ロスト人数 */
    public static StatBase lostNumber = (new StatBasic(LittleMaidCore.MODID + ".achievement.lostNumber", new ChatComponentTranslation(LittleMaidCore.MODID + ".achievement.lostNumber", new Object[0]))).initIndependentStat().registerStat();
    /** 砂糖をあげた回数 */
    public static StatBase giveSugarNumber = (new StatBasic(LittleMaidCore.MODID + ".achievement.giveSugarNumber", new ChatComponentTranslation(LittleMaidCore.MODID + ".achievement.giveSugarNumber", new Object[0]))).initIndependentStat().registerStat();

	/* 設定、MOD状態などの読み込み */
	@EventHandler
	public void preInit(FMLPreInitializationEvent event)
	{
		//Mod用Loggerの取得
		logger = event.getModLog();

		getLogger().debug("getModConfigurationDirectory:" + event.getModConfigurationDirectory().getPath());
		getLogger().debug("getSuggestedConfigurationFile:" + event.getSuggestedConfigurationFile().getPath());
		getLogger().debug("getSourceFile:" + event.getSourceFile().getPath());

		// 設定の読み込み＆保存
		// http://minecraftjp.info/modding/index.php/Configuration
		Configuration cfg = new Configuration(event.getSuggestedConfigurationFile());
		cfg.load();
		Boolean maidKey = cfg.get("maidCategory", "maidKey", false, "TestMaidConfig").getBoolean();
		getLogger().info("maidCategory_maidKey:" + maidKey.toString());
		cfg.save();

		// ブロックの登録
		//GameRegistry.registerBlock(block, name);

		// アイテムの登録
		//GameRegistry.registerItem(item, name);

		// Entityの登録
		registerEntity(EntityLittleMaid.class, MODID);

		// Guiイベントハンドラの登録
		NetworkRegistry.INSTANCE.registerGuiHandler(this.instance, new GuiHandlerLittleMaid());

		// フラグ型実績の追加(必ずinitの前に)
		/*
		// 実績枠を作る
 		Achievement employMaid = (new Achievement(LittleMaidCore.MODID + ".achievement.employMaid", "employMaid", 0, 0, Items.cake, (Achievement)null)).setIndependent();
		Achievement[] achievements = new Achievement[] {employMaid};
		// 実績ページを作成
		AchievementPage.registerAchievementPage(new AchievementPage(LittleMaidCore.MODID, achievements));
		*/

		/** 実績の使い方
		// 実績の解除方法(フラグ立てのみ)
		player.triggerAchievement(LittleMaidCore.employMaid);

		// 統計の加算方法(カウントアップ)
		player.addStat(LittleMaidCore.giveSugarNumber, 1);
		*/
	}

	/* MODの初期化 */
	@EventHandler
	public void init(FMLInitializationEvent event)
	{
		// レシピの追加、他のModへのメッセージ送信など

		// レシピの登録
		//GameRegistry.addRecipe(
		//		new ItemStack(itemIn, amount), /* 作るもの、数 */
		//		new Object[] {"", 's', Items.sugar} /* 並べ方＆材料 */);

		// サーバー、クライアントそれぞれに応じた初期化を行う
		proxy.init();

		// Mod独自のメッセージクラスとそれを受け取るクラスの定義
		// クライアントでサウンドを鳴らしたい時に送るメッセージ（playSoundはサーバー側で呼ばないと再生されない）
		MESSAGE.registerMessage(MessagePlaySoundHandler.class, MessagePlaySound.class, 0, Side.SERVER);
		// 装備品の同期
		MESSAGE.registerMessage(MessageSyncEquipHandler.class, MessageSyncEquip.class, 1, Side.CLIENT);
		// 装備品の同期要求
		MESSAGE.registerMessage(MessageRequestEquipHandler.class, MessageRequestEquip.class, 2, Side.SERVER);

		// イベントハンドラの登録
		MinecraftForge.EVENT_BUS.register(new LittleMaidEventHandler());

	}

	/* 他のMODもすべて読み込んだあとに呼ばれる */
	@EventHandler
	public void postInit(FMLPostInitializationEvent event)
	{
		// 他のModとの相互作用処理

	}

	/**
	 * Mod用Loggerの取得
	 * @return org.apache.logging.log4j.Logger
	 */
	public static Logger getLogger()
	{
		return logger;
	}

	/**
	 * エンティティの登録の一連の処理をまとめた関数
	 * @param entityClass 登録するエンティティのクラス
	 * @param name エンティティ名
	 */
	public static void registerEntity(Class entityClass, String name)
	{
		int entityID = EntityRegistry.findGlobalUniqueEntityId();
		//		long seed = name.hashCode();
		//		Random rand = new Random(seed);
		//		int primaryColor = rand.nextInt() * 16777215;
		//		int secondaryColor = rand.nextInt() * 16777215;
		int primaryColor = getColorInt(255, 255, 255);
		int secondaryColor = getColorInt(255, 0, 0);

		EntityRegistry.registerGlobalEntityID(entityClass, name, entityID);
		EntityRegistry.registerModEntity(entityClass, name, entityID, instance, 64, 1, true);
		EntityList.entityEggs.put(
			Integer.valueOf(entityID),
			new EntityList.EntityEggInfo(entityID, primaryColor, secondaryColor)
			);
	}

	/**
	 * RGB指定によって、色を示すint値を得る
	 * @param red 赤 0～255
	 * @param green 緑 0～255
	 * @param blue 青 0～255
	 * @return 24bitカラー
	 */
	public static int getColorInt(int red, int green, int blue)
	{
		red &= 255;
		green &= 255;
		blue &= 255;
		return red << 16 | green << 8 | blue;
	}

}
