# coding: utf-8
require 'optparse'
require 'pathname'

require_relative 'protobuf/parser.rb'
require_relative 'protobuf/ast'
require_relative 'protobuf/typedict'
require_relative 'protobuf/cgenerator'

option = Hash.new
OptionParser.new do |opt|
  option[:c_out] = "./"
  option[:proto_path] = Array.new
  option[:src] = Array.new

  opt.on('-I', '--proto_path=DIR,DIR...', Array, 'directory for import files.'){|v| option[:proto_path].concat v}
  opt.on('--c_out=DEST_DIR', String, "output directory."){|v| option[:c_out] = v}
  opt.on('--src=SRC_PROTO,SRC_PROTO,..', Array, '.proto source file.'){|v| option[:src].concat v}
  
  opt.parse!(ARGV)
end

class ProtobufCompiler
  def initialize(src)
    @dict = Protobuf::TypeDict.new()
    @ir = Protobuf::Parser.new().parse_start(src)
    @ir.enum_for(:each_message).each { |msg|
      @dict.store msg
    }
    @cgen = Protobuf::CGenerator.new @ir.enum_for(:each_message), @dict
  end

  def generate_header
    @cgen.generate_header
  end

  def generate_source(header_file_name)
    @cgen.generate_source header_file_name
  end
end

compiler = ProtobufCompiler.new <<EOS
message TestMessage {
  required int32 test1 = 1;
  required string test2 = 2;
  optional bytes test3 = 3;
  optional Test0.Test1.Test2 test4 = 4;
}
EOS

compiler.generate_header

option[:src].each { |file|
  dest_fname_base = Pathname.new(option[:c_out]) + File.basename(file, ".*")

  File.open(file) { |fd|
    src = fd.read
    compiler = ProtobufCompiler.new src
    dest_header = compiler.generate_header

    dest_fname_base.sub_ext('.pb.h').open('w') { |fd|
      fd.write dest_header
    }

    dest_source = compiler.generate_source dest_fname_base.sub_ext('.pb.h').relative_path_from(dest_fname_base.dirname)

    dest_fname_base.sub_ext('.pb.c').open('w') { |fd|
      fd.write dest_source
    }
  }
}
