require 'test/unit'
require_relative 'ast.rb'

class ProtobufAstTest < Test::Unit::TestCase
  def test_ast_chain_message
    assert_nothing_raised("construct") {
      message0 = Protobuf::ASTMessage.new "msg0", nil
      message1 = Protobuf::ASTMessage.new "msg1", nil 
      root = Protobuf::ASTRoot.new [message0, message1]
    }
  end

  def test_ast_chain_field
    assert_nothing_raised("construct") {
      field0 = Protobuf::ASTField.new :required, :int32, "f1", 1
      field1 = Protobuf::ASTField.new :optional, :string, "f2", 2
      message0 = Protobuf::ASTMessage.new "msg0", [field0, field1]
      field2 = Protobuf::ASTField.new :required, :int32, "f1", 1
      field3 = Protobuf::ASTField.new :optional, :string, "f2", 2
      message1 = Protobuf::ASTMessage.new "msg1", [field2, field3]
      root = Protobuf::ASTRoot.new [message0, message1]
    }
  end

  def test_ast_each_message
    field0 = Protobuf::ASTField.new :required, :int32, "f1", 1
    field1 = Protobuf::ASTField.new :optional, :string, "f2", 2
    message0 = Protobuf::ASTMessage.new "msg0", [field0, field1]
    field2 = Protobuf::ASTField.new :required, :int32, "f1", 1
    field3 = Protobuf::ASTField.new :optional, :string, "f2", 2
    message1 = Protobuf::ASTMessage.new "msg1", [field2, field3, message0]
    field4 = Protobuf::ASTField.new :required, :int32, "f1", 1
    field5 = Protobuf::ASTField.new :optional, :string, "f2", 2
    message2 = Protobuf::ASTMessage.new "msg2", [field2, field3]
    root = Protobuf::ASTRoot.new [message1, message2]

    result = Array.new
    root.each_message { |message|
      assert(message.is_a?(Protobuf::ASTMessage), "invalid object") { }
      result.push message
    }
    assert(result.size == 3, "invalid number") { }
    assert(result.include?(message0), "include message0 fail") { }
    assert(result.include?(message1), "include message1 fail") { }
    assert(result.include?(message2), "include message2 fail") { }
  end

  def test_ast_each_field
    field0 = Protobuf::ASTField.new :required, :int32, "f1", 1
    field1 = Protobuf::ASTField.new :optional, :string, "f2", 2
    message0 = Protobuf::ASTMessage.new "msg0", [field0, field1]
    field2 = Protobuf::ASTField.new :required, :int32, "f1", 1
    field3 = Protobuf::ASTField.new :optional, :string, "f2", 2
    message1 = Protobuf::ASTMessage.new "msg1", [field2, field3, message0]

    result = Array.new
    message1.each_field { |field|
      assert(field.is_a?(Protobuf::ASTField), "invalid object") { }
      result.push field
    }
    assert(result.size == 2, "invalid number") { }
    assert(result.include?(field2), "include field2 fail") { }
    assert(result.include?(field3), "include field3 fail") { }
  end

  def test_absolute_name
    field0 = Protobuf::ASTField.new :required, :int32, "f1", 1
    field1 = Protobuf::ASTField.new :optional, :string, "f2", 2
    message0 = Protobuf::ASTMessage.new "msg0", [field0, field1]
    field2 = Protobuf::ASTField.new :required, :int32, "f1", 1
    field3 = Protobuf::ASTField.new :optional, :string, "f2", 2
    message1 = Protobuf::ASTMessage.new "msg1", [field2, field3, message0]
    field4 = Protobuf::ASTField.new :required, :int32, "f1", 1
    field5 = Protobuf::ASTField.new :optional, :string, "f2", 2
    message2 = Protobuf::ASTMessage.new "msg2", [field4, field5, message1]
    root = Protobuf::ASTRoot.new [message2]

    assert(message0.absolute_name == 'msg2.msg1.msg0', 'invalid absolute name 0') { }
    assert(message1.absolute_name == 'msg2.msg1', 'invalid absolute name 1') { }
    assert(message2.absolute_name == 'msg2', 'invalid absolute name 2') { }
  end

  def test_field_owner_message
    field0 = Protobuf::ASTField.new :required, :int32, "f1", 1
    field1 = Protobuf::ASTField.new :optional, :string, "f2", 2
    message0 = Protobuf::ASTMessage.new "msg0", [field0, field1]
    field2 = Protobuf::ASTField.new :required, :int32, "f1", 1
    field3 = Protobuf::ASTField.new :optional, :string, "f2", 2
    message1 = Protobuf::ASTMessage.new "msg1", [field2, field3, message0]
    field4 = Protobuf::ASTField.new :required, :int32, "f1", 1
    field5 = Protobuf::ASTField.new :optional, :string, "f2", 2
    message2 = Protobuf::ASTMessage.new "msg2", [field4, field5, message1]
    root = Protobuf::ASTRoot.new [message2]

    assert(field0.owner_message == message0, 'invalid owner 0') { }
    assert(field1.owner_message == message0, 'invalid owner 1') { }
    assert(field2.owner_message == message1, 'invalid owner 2') { }
    assert(field3.owner_message == message1, 'invalid owner 3') { }
    assert(field4.owner_message == message2, 'invalid owner 4') { }
    assert(field5.owner_message == message2, 'invalid owner 5') { }
  end

  def test_enum
    field0 = Protobuf::ASTEnumConstant.new "f1", 1
    field1 = Protobuf::ASTEnumConstant.new "f2", 2
    enum0 = Protobuf::ASTEnum.new "enum0", [field0, field1]

    result = enum0.enum_for(:each_constant).to_a
    assert(result.all? {|i| i.is_a?(Protobuf::ASTEnumConstant) }, "invald object") {}
    assert(result.size == 2, "invalid number") { }
    assert(result.include?(field0), "include field0 fail") { }
    assert(result.include?(field1), "include field1 fail") { }
  end
end
