/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package parser;

import grammar.Nod;
import grammar.Seq;
import grammar.Rep;
import context.IContext;
import static org.testng.Assert.*;
import org.testng.annotations.Test;
import static grammar.Convenients.eq;
import static parser.Fixture.testList2;

/**
 *
 * @author mtomono
 */
public class MRep {
    
    public MRep() {
    }

    String test0 = "test0";
    String test1 = "test1";

    @Test
    public void rep_success() {
        IContext<String> c = IContext.c(testList2, 2);
        assertTrue(ParseAndStay.matches(new Rep<>(new Seq<>(new Nod<>(eq(test0)), new Nod<>(eq(test1)))), c));
    }

    @Test
    public void rep_success2() {
        IContext<String> c = IContext.c(testList2, 2);
        assertTrue(ParseAndStay.matches(new Rep<>(new Seq<>(new Nod<>(eq(test0)), new Nod<>(eq(test1))), 1, 3), c));
    }

    @Test
    public void rep_success3() {
        IContext<String> c = IContext.c(testList2, 2);
        assertTrue(ParseAndStay.matches(new Rep<>(new Seq<>(new Nod<>(eq(test0)), new Nod<>(eq(test1))), 1, 1), c));
    }

    @Test
    public void rep_fail1() {
        IContext<String> c = IContext.c(testList2, 2);
        assertFalse(ParseAndStay.matches(new Rep<>(new Seq<>(new Nod<>(eq(test0)), new Nod<>(eq(test1))), 3, 4), c));
    }

    @Test
    public void rep_fail2() {
        IContext<String> c = IContext.c(testList2, 2);
        assertFalse(ParseAndStay.matches(new Rep<>(new Seq<>(new Nod<>(eq(test1)), new Nod<>(eq(test0))), 1, 4), c));
    }
}
