/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package orderedSet;

import iterator.AbstractIterator;
import java.util.ListIterator;

/**
 *
 * @author mtomono
 */
abstract public class Walker<Left, Right> extends AbstractIterator<Boolean> {
    Left left;
    Right right;
    ListIterator<Left> iterL;
    ListIterator<Right> iterR;
    boolean ready;
    
    abstract public boolean leftCatchesRight(Left left, Right right);
    abstract public boolean doesRightStay(Left left, Right right);
    abstract public boolean matches(Left left, Right right);
    abstract public void whenLeftIsOver();
    
    final boolean checkBase() {
        iterL = new AssertOrderListIterator<>(iterL);
        iterR = new AssertOrderListIterator<>(iterR);
        return true;
    }
    
    public Walker(ListIterator<Left> iterL, ListIterator<Right> iterR) {
        this.iterL = iterL;
        this.iterR = iterR;
        assert checkBase();
        this.ready = false;
    }
    
    public Left left() {
        return left;
    }
    
    public Right right() {
        return right;
    }

    @Override
    protected void findNext() {
        if (!iterR.hasNext())
            return;
        right = iterR.next();
        do {
            if (!iterL.hasNext()) {
                whenLeftIsOver();
                return;
            }
            left = iterL.next();
        } while (!leftCatchesRight(left, right));
        if (doesRightStay(left, right))
            iterR.previous();
        else
            iterL.previous();
        nextFound(matches(left, right));
    }
    
}
