/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package orderedSet;

import iterator.AbstractIterator;
import java.util.ListIterator;

/**
 *
 * @author mtomono
 */
public class NegateRangeIterator<T extends Comparable<T>> extends AbstractIterator<Range<T>> {
    Range<T> target;
    ListIterator<Range<T>> iter;
    boolean finished;
    
    final boolean checkBase() {
        iter = new AssertOrderListIterator<>(iter);
        return true;
    }
    
    public NegateRangeIterator(Range<T> target, ListIterator<Range<T>> iter) {
        this.target = target;
        this.iter = iter;
        assert checkBase();
        this.finished = false;
        seekToTarget();
    }
    
    private void seekToTarget() {
        while (iter.hasNext()) {
            Range<T> range = iter.next();
            if (!range.isLowerThan(target)) {
                if (range.contains(target))
                    finished = true;
                else if (!range.startsUpperThan(target)) {
                    target = range.getUpperRoomIn(target);
                } else 
                    iter.previous();
                return;
            }
        }
    }
    
    @Override
    protected void findNext() {
        if (finished)
            return;
        if (!iter.hasNext()) {
            nextFound(target);
            finished = true;
            return;
        }
        Range<T> range = iter.next();
        if (range.isUpperThan(target)) {
            if (!(target.isEmpty()))
                nextFound(target);
            finished = true;
            return;
        }
        nextFound(range.getLowerRoomIn(target));
        
        if (!range.endsLowerThan(target))
            finished = true;
        else {
            target = range.getUpperRoomIn(target);
        }
    }
    
}
