/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package collection;

import java.util.AbstractList;
import java.util.List;

/**
 *
 * @author mtomono
 */
abstract public class View<T> extends AbstractList<T> {
    List<T> body;
    
    abstract public int at(int index);
    
    public View(List<T> body) {
        this.body = body;
    }
    
    @Override
    public T get(int index) {
        return body.get(at(index));
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }
    
    @Override
    public T set(int i, T e) {
        return body.set(at(i), e);
    }
    
    @Override
    public boolean add(T e) {
        add(at(size()), e);
        return true;
    }
    
    @Override
    public void add(int i, T e) {
        add(at(i), e);
    }
}
